/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge;

import net.javaforge.netty.servlet.bridge.impl.HttpSessionImpl;
import net.javaforge.netty.servlet.bridge.impl.ServletBridgeWebapp;
import net.javaforge.netty.servlet.bridge.session.ServletBridgeHttpSessionStore;

public class HttpSessionThreadLocal {
    public static final ThreadLocal<HttpSessionImpl> sessionThreadLocal = new ThreadLocal();
    private static ServletBridgeHttpSessionStore sessionStore;

    public static ServletBridgeHttpSessionStore getSessionStore() {
        return sessionStore;
    }

    public static void setSessionStore(ServletBridgeHttpSessionStore store) {
        sessionStore = store;
    }

    public static void set(HttpSessionImpl session) {
        sessionThreadLocal.set(session);
    }

    public static void unset() {
        sessionThreadLocal.remove();
    }

    public static HttpSessionImpl get() {
        HttpSessionImpl session = sessionThreadLocal.get();
        if (session != null) {
            session.touch();
        }
        return session;
    }

    public static HttpSessionImpl getOrCreate() {
        if (HttpSessionThreadLocal.get() == null) {
            HttpSessionImpl newSession = sessionStore.createSession();
            newSession.setMaxInactiveInterval(ServletBridgeWebapp.get().getWebappConfig().getSessionTimeout());
            sessionThreadLocal.set(sessionStore.createSession());
        }
        return HttpSessionThreadLocal.get();
    }
}

