/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge;

import net.javaforge.netty.servlet.bridge.ServletBridgeHandler;
import net.javaforge.netty.servlet.bridge.config.WebappConfiguration;
import net.javaforge.netty.servlet.bridge.impl.ServletBridgeWebapp;
import net.javaforge.netty.servlet.bridge.interceptor.ChannelInterceptor;
import net.javaforge.netty.servlet.bridge.interceptor.HttpSessionInterceptor;
import net.javaforge.netty.servlet.bridge.session.DefaultServletBridgeHttpSessionStore;
import net.javaforge.netty.servlet.bridge.session.ServletBridgeHttpSessionStore;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class ServletBridgeChannelPipelineFactory
implements ChannelPipelineFactory {
    private ChannelGroup allChannels = new DefaultChannelGroup();
    private HttpSessionWatchdog watchdog;
    private final ChannelHandler idleStateHandler;
    private Timer timer = new HashedWheelTimer();

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    public void setAllChannels(ChannelGroup allChannels) {
        this.allChannels = allChannels;
    }

    public ServletBridgeChannelPipelineFactory(WebappConfiguration config) {
        this.idleStateHandler = new IdleStateHandler(this.timer, 60, 30, 0);
        ServletBridgeWebapp webapp = ServletBridgeWebapp.get();
        webapp.init(config, this.allChannels);
        this.watchdog = new HttpSessionWatchdog();
        new Thread(this.watchdog).start();
    }

    public void shutdown() {
        this.watchdog.stopWatching();
        ServletBridgeWebapp.get().destroy();
        this.timer.stop();
        this.allChannels.close().awaitUninterruptibly();
    }

    public final ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = this.getDefaulHttpChannelPipeline();
        pipeline.addLast("handler", (ChannelHandler)this.getServletBridgeHandler());
        return pipeline;
    }

    protected ServletBridgeHttpSessionStore getHttpSessionStore() {
        return new DefaultServletBridgeHttpSessionStore();
    }

    protected ServletBridgeHandler getServletBridgeHandler() {
        ServletBridgeHandler bridge = new ServletBridgeHandler();
        bridge.addInterceptor(new ChannelInterceptor());
        bridge.addInterceptor(new HttpSessionInterceptor(this.getHttpSessionStore()));
        return bridge;
    }

    protected ChannelPipeline getDefaulHttpChannelPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(0x100000));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        pipeline.addLast("idle", this.idleStateHandler);
        return pipeline;
    }

    private class HttpSessionWatchdog
    implements Runnable {
        private boolean shouldStopWatching = false;

        private HttpSessionWatchdog() {
        }

        public void run() {
            while (!this.shouldStopWatching) {
                try {
                    ServletBridgeHttpSessionStore store = ServletBridgeChannelPipelineFactory.this.getHttpSessionStore();
                    if (store != null) {
                        store.destroyInactiveSessions();
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void stopWatching() {
            this.shouldStopWatching = true;
        }
    }
}

