/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.javaforge.netty.servlet.bridge.ServletBridgeInterceptor;
import net.javaforge.netty.servlet.bridge.ServletBridgeRuntimeException;
import net.javaforge.netty.servlet.bridge.impl.FilterChainImpl;
import net.javaforge.netty.servlet.bridge.impl.HttpServletRequestImpl;
import net.javaforge.netty.servlet.bridge.impl.HttpServletResponseImpl;
import net.javaforge.netty.servlet.bridge.impl.ServletBridgeWebapp;
import net.javaforge.netty.servlet.bridge.util.Utils;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FileRegion;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletBridgeHandler
extends IdleStateAwareChannelHandler {
    private static final Logger log = LoggerFactory.getLogger(ServletBridgeHandler.class);
    private List<ServletBridgeInterceptor> interceptors;

    public ServletBridgeHandler addInterceptor(ServletBridgeInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<ServletBridgeInterceptor>();
        }
        this.interceptors.add(interceptor);
        return this;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        log.debug("Opening new channel: {}", (Object)e.getChannel().getId());
        ServletBridgeWebapp.get().getSharedChannelGroup().add((Object)e.getChannel());
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        log.debug("Closing idle channel: {}", (Object)e.getChannel().getId());
        e.getChannel().close();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        FilterChainImpl chain;
        HttpRequest request = (HttpRequest)e.getMessage();
        if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
            e.getChannel().write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        if ((chain = ServletBridgeWebapp.get().initializeChain(request.getUri())).isValid()) {
            this.handleHttpServletRequest(ctx, e, chain);
        } else if (ServletBridgeWebapp.get().getStaticResourcesFolder() != null) {
            System.out.println("Vao handleStaticResourceRequest ");
            this.handleStaticResourceRequest(ctx, e);
        } else {
            throw new ServletBridgeRuntimeException("No handler found for uri: " + request.getUri());
        }
    }

    protected void handleHttpServletRequest(ChannelHandlerContext ctx, MessageEvent e, FilterChainImpl chain) throws Exception {
        this.interceptOnRequestReceived(ctx, e);
        HttpRequest request = (HttpRequest)e.getMessage();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpServletResponseImpl resp = this.buildHttpServletResponse((HttpResponse)response);
        HttpServletRequestImpl req = this.buildHttpServletRequest(request, chain);
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        this.interceptOnRequestSuccessed(ctx, e, (HttpResponse)response);
        resp.getWriter().flush();
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
        if (keepAlive) {
            response.setHeader("Content-Length", (Object)response.getContent().readableBytes());
            response.setHeader("Connection", (Object)"keep-alive");
        }
        ChannelFuture future = e.getChannel().write((Object)response);
        if (!keepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    protected void handleStaticResourceRequest(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        RandomAccessFile raf;
        HttpRequest request = (HttpRequest)e.getMessage();
        if (request.getMethod() != HttpMethod.GET) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String uri = Utils.sanitizeUri(request.getUri());
        String path = uri != null ? ServletBridgeWebapp.get().getStaticResourcesFolder().getAbsolutePath() + File.separator + uri : null;
        System.out.println("path " + path);
        if (path == null) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        File file = new File(path);
        if (file.isHidden() || !file.exists()) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        if (!file.isFile()) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException fnfe) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
        Channel ch = e.getChannel();
        ch.write((Object)response);
        if (this.isSslChannel(ch)) {
            ChannelFuture writeFuture = ch.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
        } else {
            DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
            ChannelFuture writeFuture = ch.write((Object)region);
            writeFuture.addListener((ChannelFutureListener)new ChannelFutureProgressListener((FileRegion)region, path){
                final /* synthetic */ FileRegion val$region;
                final /* synthetic */ String val$path;
                {
                    this.val$region = fileRegion;
                    this.val$path = string;
                }

                public void operationComplete(ChannelFuture future) {
                    this.val$region.releaseExternalResources();
                }

                public void operationProgressed(ChannelFuture future, long amount, long current, long total) {
                    System.out.printf("%s: %d / %d (+%d)%n", this.val$path, current, total, amount);
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        Throwable cause = e.getCause();
        log.error("Unexpected exception from downstream.", cause);
        Channel ch = e.getChannel();
        if (cause instanceof IllegalArgumentException) {
            ch.close();
        } else {
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (ch.isConnected()) {
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
    }

    private void interceptOnRequestReceived(ChannelHandlerContext ctx, MessageEvent e) {
        if (this.interceptors != null) {
            for (ServletBridgeInterceptor interceptor : this.interceptors) {
                interceptor.onRequestReceived(ctx, e);
            }
        }
    }

    private void interceptOnRequestSuccessed(ChannelHandlerContext ctx, MessageEvent e, HttpResponse response) {
        if (this.interceptors != null) {
            for (ServletBridgeInterceptor interceptor : this.interceptors) {
                interceptor.onRequestSuccessed(ctx, e, response);
            }
        }
    }

    protected HttpServletResponseImpl buildHttpServletResponse(HttpResponse response) {
        return new HttpServletResponseImpl(response);
    }

    protected HttpServletRequestImpl buildHttpServletRequest(HttpRequest request, FilterChainImpl chain) {
        return new HttpServletRequestImpl(request, chain);
    }

    private boolean isSslChannel(Channel ch) {
        return ch.getPipeline().get(SslHandler.class) != null;
    }
}

