/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.config;

import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.javaforge.netty.servlet.bridge.impl.ConfigAdapter;
import net.javaforge.netty.servlet.bridge.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpComponentConfigurationAdapter<COMP, CONFIG extends ConfigAdapter> {
    private static final Logger log = LoggerFactory.getLogger(HttpComponentConfigurationAdapter.class);
    private static final String DEFAULT_URL_PATTERN = "/*";
    private String[] sanitizedUrlPatterns;
    private Pattern[] regexPatterns;
    protected COMP component;
    protected CONFIG config;
    private boolean initialized = false;

    public HttpComponentConfigurationAdapter(Class<? extends COMP> componentClazz) {
        this(Utils.newInstance(componentClazz), DEFAULT_URL_PATTERN);
    }

    public HttpComponentConfigurationAdapter(Class<? extends COMP> servletClazz, String ... urlPatterns) {
        this(Utils.newInstance(servletClazz), urlPatterns);
    }

    public HttpComponentConfigurationAdapter(COMP servlet) {
        this(servlet, DEFAULT_URL_PATTERN);
    }

    public HttpComponentConfigurationAdapter(COMP component, String ... urlPatterns) {
        if (urlPatterns == null || urlPatterns.length == 0) {
            throw new IllegalStateException("No url patterns were assigned to http component: " + component);
        }
        this.regexPatterns = new Pattern[urlPatterns.length];
        this.sanitizedUrlPatterns = new String[urlPatterns.length];
        for (int i = 0; i < urlPatterns.length; ++i) {
            String regex = urlPatterns[i].replaceAll("\\*", ".*");
            this.regexPatterns[i] = Pattern.compile(regex);
            this.sanitizedUrlPatterns[i] = urlPatterns[i].replaceAll("\\*", "");
            if (!this.sanitizedUrlPatterns[i].endsWith("/")) continue;
            this.sanitizedUrlPatterns[i] = this.sanitizedUrlPatterns[i].substring(0, this.sanitizedUrlPatterns[i].length() - 1);
        }
        this.component = component;
        this.config = this.newConfigInstance(component.getClass());
    }

    protected abstract CONFIG newConfigInstance(Class<? extends COMP> var1);

    public void init() {
        try {
            log.debug("Initializing http component: {}", this.component.getClass());
            this.doInit();
            this.initialized = true;
        }
        catch (ServletException e) {
            this.initialized = false;
            log.error("Http component '" + this.component.getClass() + "' was not initialized!", (Throwable)e);
        }
    }

    public void destroy() {
        try {
            log.debug("Destroying http component: {}", this.component.getClass());
            this.doDestroy();
            this.initialized = false;
        }
        catch (ServletException e) {
            this.initialized = false;
            log.error("Http component '" + this.component.getClass() + "' was not destroyed!", (Throwable)e);
        }
    }

    protected abstract void doInit() throws ServletException;

    protected abstract void doDestroy() throws ServletException;

    public boolean matchesUrlPattern(String uri) {
        return this.getMatchingUrlPattern(uri) != null;
    }

    public String getMatchingUrlPattern(String uri) {
        String path;
        int indx = uri.indexOf(63);
        String string = path = indx != -1 ? uri.substring(0, indx) : uri.substring(0);
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        for (int i = 0; i < this.regexPatterns.length; ++i) {
            Pattern pattern = this.regexPatterns[i];
            if (!pattern.matcher(path).matches()) continue;
            return this.sanitizedUrlPatterns[i];
        }
        return null;
    }

    protected void addConfigInitParameter(String name, String value) {
        ((ConfigAdapter)this.config).addInitParameter(name, value);
    }

    public COMP getHttpComponent() {
        return this.component;
    }

    public CONFIG getConfig() {
        return this.config;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

