/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.config;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.javaforge.netty.servlet.bridge.impl.ServletContextImpl;
import net.javaforge.netty.servlet.bridge.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextListenerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ServletContextListenerConfiguration.class);
    private ServletContextListener listener;
    private boolean initialized = false;

    public ServletContextListenerConfiguration(Class<? extends ServletContextListener> clazz) {
        this(Utils.newInstance(clazz));
    }

    public ServletContextListenerConfiguration(ServletContextListener listener) {
        this.listener = listener;
    }

    public ServletContextListener getListener() {
        return this.listener;
    }

    public void init() {
        try {
            log.debug("Initializing listener: {}", this.listener.getClass());
            this.listener.contextInitialized(new ServletContextEvent((ServletContext)ServletContextImpl.get()));
            this.initialized = true;
        }
        catch (Exception e) {
            this.initialized = false;
            log.error("Listener '" + this.listener.getClass() + "' was not initialized!", (Throwable)e);
        }
    }

    public void destroy() {
        try {
            log.debug("Destroying listener: {}", this.listener.getClass());
            this.listener.contextDestroyed(new ServletContextEvent((ServletContext)ServletContextImpl.get()));
            this.initialized = false;
        }
        catch (Exception e) {
            this.initialized = false;
            log.error("Listener '" + this.listener.getClass() + "' was not destroyed!", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

