/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.impl;

import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import net.javaforge.netty.servlet.bridge.config.FilterConfiguration;
import net.javaforge.netty.servlet.bridge.config.ServletConfiguration;

public class FilterChainImpl
implements FilterChain {
    private LinkedList<FilterConfiguration> filterConfigurations;
    private ServletConfiguration servletConfiguration;

    public FilterChainImpl(ServletConfiguration servletConfiguration) {
        this.servletConfiguration = servletConfiguration;
    }

    public void addFilterConfiguration(FilterConfiguration config) {
        if (this.filterConfigurations == null) {
            this.filterConfigurations = new LinkedList();
        }
        this.filterConfigurations.add(config);
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        FilterConfiguration config;
        FilterConfiguration filterConfiguration = config = this.filterConfigurations != null ? this.filterConfigurations.poll() : null;
        if (config != null) {
            ((Filter)config.getHttpComponent()).doFilter(request, response, (FilterChain)this);
        } else if (this.servletConfiguration != null) {
            ((HttpServlet)this.servletConfiguration.getHttpComponent()).service(request, response);
        }
    }

    public boolean isValid() {
        return this.servletConfiguration != null || this.filterConfigurations != null && !this.filterConfigurations.isEmpty();
    }

    public ServletConfiguration getServletConfiguration() {
        return this.servletConfiguration;
    }
}

