/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.javaforge.netty.servlet.bridge.ChannelThreadLocal;
import net.javaforge.netty.servlet.bridge.HttpSessionThreadLocal;
import net.javaforge.netty.servlet.bridge.impl.FilterChainImpl;
import net.javaforge.netty.servlet.bridge.impl.HttpSessionImpl;
import net.javaforge.netty.servlet.bridge.impl.ServletContextImpl;
import net.javaforge.netty.servlet.bridge.impl.ServletInputStreamImpl;
import net.javaforge.netty.servlet.bridge.impl.URIParser;
import net.javaforge.netty.servlet.bridge.util.Utils;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.ssl.SslHandler;

public class HttpServletRequestImpl
implements HttpServletRequest {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private URIParser uriParser;
    private HttpRequest originalRequest;
    private ServletInputStreamImpl inputStream;
    private BufferedReader reader;
    private QueryStringDecoder queryStringDecoder;
    private Map<String, Object> attributes;
    private CookieDecoder cookieDecoder = new CookieDecoder();
    private String characterEncoding;

    public HttpServletRequestImpl(HttpRequest request, FilterChainImpl chain) {
        this.originalRequest = request;
        this.inputStream = new ServletInputStreamImpl(request);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.inputStream)));
        this.queryStringDecoder = new QueryStringDecoder(request.getUri());
        this.uriParser = new URIParser(chain);
        this.uriParser.parse(request.getUri());
        this.characterEncoding = Utils.getCharsetFromContentType(this.getContentType());
    }

    public HttpRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public String getContextPath() {
        return ServletContextImpl.get().getContextPath();
    }

    public javax.servlet.http.Cookie[] getCookies() {
        Set cookies;
        String cookieString = this.originalRequest.getHeader("Cookie");
        if (cookieString != null && !(cookies = this.cookieDecoder.decode(cookieString)).isEmpty()) {
            javax.servlet.http.Cookie[] cookiesArray = new javax.servlet.http.Cookie[cookies.size()];
            int indx = 0;
            for (Cookie c : cookies) {
                javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(c.getName(), c.getValue());
                cookie.setComment(c.getComment());
                if (c.getDomain() != null) {
                    cookie.setDomain(c.getDomain());
                }
                cookie.setMaxAge(c.getMaxAge());
                cookie.setPath(c.getPath());
                cookie.setSecure(c.isSecure());
                cookie.setVersion(c.getVersion());
                cookiesArray[indx] = cookie;
                ++indx;
            }
            return cookiesArray;
        }
        return null;
    }

    public long getDateHeader(String name) {
        String longVal = this.getHeader(name);
        if (longVal == null) {
            return -1L;
        }
        return Long.parseLong(longVal);
    }

    public String getHeader(String name) {
        return HttpHeaders.getHeader((HttpMessage)this.originalRequest, (String)name);
    }

    public Enumeration getHeaderNames() {
        return Utils.enumeration(this.originalRequest.getHeaderNames());
    }

    public Enumeration getHeaders(String name) {
        return Utils.enumeration(this.originalRequest.getHeaders(name));
    }

    public int getIntHeader(String name) {
        return HttpHeaders.getIntHeader((HttpMessage)this.originalRequest, (String)name, (int)-1);
    }

    public String getMethod() {
        return this.originalRequest.getMethod().getName();
    }

    public String getQueryString() {
        return this.uriParser.getQueryString();
    }

    public String getRequestURI() {
        return this.uriParser.getRequestUri();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        String urlPath = this.getRequestURI();
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(this.getServerPort());
        }
        url.append(urlPath);
        return url;
    }

    public int getContentLength() {
        return (int)HttpHeaders.getContentLength((HttpMessage)this.originalRequest, (long)-1L);
    }

    public String getContentType() {
        return HttpHeaders.getHeader((HttpMessage)this.originalRequest, (String)"Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values != null ? values[0] : null;
    }

    public Map getParameterMap() {
        return this.queryStringDecoder.getParameters();
    }

    public Enumeration getParameterNames() {
        return Utils.enumerationFromKeys(this.queryStringDecoder.getParameters());
    }

    public String[] getParameterValues(String name) {
        List values = (List)this.queryStringDecoder.getParameters().get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public String getProtocol() {
        return this.originalRequest.getProtocolVersion().toString();
    }

    public Object getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        return Utils.enumerationFromKeys(this.attributes);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object o) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, o);
    }

    public BufferedReader getReader() throws IOException {
        return this.reader;
    }

    public String getRequestedSessionId() {
        HttpSessionImpl session = HttpSessionThreadLocal.get();
        return session != null ? session.getId() : null;
    }

    public HttpSession getSession() {
        HttpSessionImpl s = HttpSessionThreadLocal.getOrCreate();
        return s;
    }

    public HttpSession getSession(boolean create) {
        HttpSessionImpl session = HttpSessionThreadLocal.get();
        if (session == null && create) {
            session = HttpSessionThreadLocal.getOrCreate();
        }
        return session;
    }

    public String getPathInfo() {
        return this.uriParser.getPathInfo();
    }

    public Locale getLocale() {
        String locale = HttpHeaders.getHeader((HttpMessage)this.originalRequest, (String)"Accept-Language", (String)DEFAULT_LOCALE.toString());
        return new Locale(locale);
    }

    public String getRemoteAddr() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getRemoteAddress();
        return addr.getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getRemoteAddress();
        return addr.getHostName();
    }

    public int getRemotePort() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getRemoteAddress();
        return addr.getPort();
    }

    public String getServerName() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getLocalAddress();
        return addr.getHostName();
    }

    public int getServerPort() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getLocalAddress();
        return addr.getPort();
    }

    public String getServletPath() {
        String servletPath = this.uriParser.getServletPath();
        if (servletPath.equals("/")) {
            return "";
        }
        return servletPath;
    }

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public boolean isSecure() {
        return ChannelThreadLocal.get().getPipeline().get(SslHandler.class) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public String getLocalAddr() {
        InetSocketAddress addr = (InetSocketAddress)ChannelThreadLocal.get().getLocalAddress();
        return addr.getAddress().getHostAddress();
    }

    public String getLocalName() {
        return this.getServerName();
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncoding = env;
    }

    public Enumeration getLocales() {
        Collection<Locale> locales = Utils.parseAcceptLanguageHeader(HttpHeaders.getHeader((HttpMessage)this.originalRequest, (String)"Accept-Language"));
        if (locales == null || locales.isEmpty()) {
            locales = new ArrayList<Locale>();
            locales.add(Locale.getDefault());
        }
        return Utils.enumeration(locales);
    }

    public String getAuthType() {
        throw new IllegalStateException("Method 'getAuthType' not yet implemented!");
    }

    public String getPathTranslated() {
        throw new IllegalStateException("Method 'getPathTranslated' not yet implemented!");
    }

    public String getRemoteUser() {
        throw new IllegalStateException("Method 'getRemoteUser' not yet implemented!");
    }

    public Principal getUserPrincipal() {
        throw new IllegalStateException("Method 'getUserPrincipal' not yet implemented!");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new IllegalStateException("Method 'isRequestedSessionIdFromURL' not yet implemented!");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new IllegalStateException("Method 'isRequestedSessionIdFromUrl' not yet implemented!");
    }

    public boolean isRequestedSessionIdValid() {
        throw new IllegalStateException("Method 'isRequestedSessionIdValid' not yet implemented!");
    }

    public boolean isUserInRole(String role) {
        throw new IllegalStateException("Method 'isUserInRole' not yet implemented!");
    }

    public String getRealPath(String path) {
        throw new IllegalStateException("Method 'getRealPath' not yet implemented!");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new IllegalStateException("Method 'getRequestDispatcher' not yet implemented!");
    }
}

