/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.javaforge.netty.servlet.bridge.ServletBridgeRuntimeException;
import net.javaforge.netty.servlet.bridge.impl.PrintWriterImpl;
import net.javaforge.netty.servlet.bridge.impl.ServletOutputStreamImpl;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private HttpResponse originalResponse;
    private ServletOutputStreamImpl outputStream;
    private PrintWriterImpl writer;
    private boolean responseCommited = false;

    public HttpServletResponseImpl(HttpResponse response) {
        this.originalResponse = response;
        this.outputStream = new ServletOutputStreamImpl(response);
        this.writer = new PrintWriterImpl((OutputStream)((Object)this.outputStream));
    }

    public HttpResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public void addCookie(Cookie cookie) {
        CookieEncoder cookieEncoder = new CookieEncoder(true);
        cookieEncoder.addCookie(cookie.getName(), cookie.getValue());
        HttpHeaders.addHeader((HttpMessage)this.originalResponse, (String)"Set-Cookie", (Object)cookieEncoder.encode());
    }

    public void addDateHeader(String name, long date) {
        HttpHeaders.addHeader((HttpMessage)this.originalResponse, (String)name, (Object)date);
    }

    public void addHeader(String name, String value) {
        HttpHeaders.addHeader((HttpMessage)this.originalResponse, (String)name, (Object)value);
    }

    public void addIntHeader(String name, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.originalResponse, (String)name, (int)value);
    }

    public boolean containsHeader(String name) {
        return this.originalResponse.containsHeader(name);
    }

    public void sendError(int sc) throws IOException {
        this.originalResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    public void sendError(int sc, String msg) throws IOException {
        this.originalResponse.setStatus(new HttpResponseStatus(sc, msg));
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long date) {
        HttpHeaders.setHeader((HttpMessage)this.originalResponse, (String)name, (Object)date);
    }

    public void setHeader(String name, String value) {
        HttpHeaders.setHeader((HttpMessage)this.originalResponse, (String)name, (Object)value);
    }

    public void setIntHeader(String name, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.originalResponse, (String)name, (int)value);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void setStatus(int sc) {
        this.originalResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    public void setStatus(int sc, String sm) {
        this.originalResponse.setStatus(new HttpResponseStatus(sc, sm));
    }

    public void setContentType(String type) {
        HttpHeaders.setHeader((HttpMessage)this.originalResponse, (String)"Content-Type", (Object)type);
    }

    public void setContentLength(int len) {
        HttpHeaders.setContentLength((HttpMessage)this.originalResponse, (long)len);
    }

    public boolean isCommitted() {
        return this.responseCommited;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already commited!");
        }
        this.originalResponse.clearHeaders();
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already commited!");
        }
        this.outputStream.resetBuffer();
    }

    public void flushBuffer() throws IOException {
        this.getWriter().flush();
        this.responseCommited = true;
    }

    public int getBufferSize() {
        return this.outputStream.getBufferSize();
    }

    public void setBufferSize(int size) {
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletBridgeRuntimeException("Error encoding url!", e);
        }
    }

    public String encodeUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String getCharacterEncoding() {
        throw new IllegalStateException("Method 'getCharacterEncoding' not yet implemented!");
    }

    public String getContentType() {
        throw new IllegalStateException("Method 'getContentType' not yet implemented!");
    }

    public Locale getLocale() {
        throw new IllegalStateException("Method 'getLocale' not yet implemented!");
    }

    public void setCharacterEncoding(String charset) {
        throw new IllegalStateException("Method 'setCharacterEncoding' not yet implemented!");
    }

    public void setLocale(Locale loc) {
        throw new IllegalStateException("Method 'setLocale' not yet implemented!");
    }
}

