/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.impl;

import java.io.File;
import java.util.Map;
import net.javaforge.netty.servlet.bridge.config.FilterConfiguration;
import net.javaforge.netty.servlet.bridge.config.ServletConfiguration;
import net.javaforge.netty.servlet.bridge.config.ServletContextListenerConfiguration;
import net.javaforge.netty.servlet.bridge.config.WebappConfiguration;
import net.javaforge.netty.servlet.bridge.impl.FilterChainImpl;
import net.javaforge.netty.servlet.bridge.impl.ServletContextImpl;
import org.jboss.netty.channel.group.ChannelGroup;

public class ServletBridgeWebapp {
    private static ServletBridgeWebapp instance;
    private WebappConfiguration webappConfig;
    private ChannelGroup sharedChannelGroup;

    public static final ServletBridgeWebapp get() {
        if (instance == null) {
            instance = new ServletBridgeWebapp();
        }
        return instance;
    }

    public void init(WebappConfiguration webapp, ChannelGroup sharedChannelGroup) {
        this.webappConfig = webapp;
        this.sharedChannelGroup = sharedChannelGroup;
        this.initServletContext();
        this.initContextListeners();
        this.initFilters();
        this.initServlets();
    }

    public void destroy() {
        this.destroyServlets();
        this.destroyFilters();
        this.destroyContextListeners();
    }

    private void initContextListeners() {
        if (this.webappConfig.getServletContextListenerConfigurations() != null) {
            for (ServletContextListenerConfiguration ctx : this.webappConfig.getServletContextListenerConfigurations()) {
                ctx.init();
            }
        }
    }

    private void destroyContextListeners() {
        if (this.webappConfig.getServletContextListenerConfigurations() != null) {
            for (ServletContextListenerConfiguration ctx : this.webappConfig.getServletContextListenerConfigurations()) {
                ctx.destroy();
            }
        }
    }

    private void destroyServlets() {
        if (this.webappConfig.getServletConfigurations() != null) {
            for (ServletConfiguration servlet : this.webappConfig.getServletConfigurations()) {
                servlet.destroy();
            }
        }
    }

    private void destroyFilters() {
        if (this.webappConfig.getFilterConfigurations() != null) {
            for (FilterConfiguration filter : this.webappConfig.getFilterConfigurations()) {
                filter.destroy();
            }
        }
    }

    protected void initServletContext() {
        ServletContextImpl ctx = ServletContextImpl.get();
        ctx.setServletContextName(this.webappConfig.getName());
        if (this.webappConfig.getContextParameters() != null) {
            for (Map.Entry<String, String> entry : this.webappConfig.getContextParameters().entrySet()) {
                ctx.addInitParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void initFilters() {
        if (this.webappConfig.getFilterConfigurations() != null) {
            for (FilterConfiguration filter : this.webappConfig.getFilterConfigurations()) {
                filter.init();
            }
        }
    }

    protected void initServlets() {
        if (this.webappConfig.hasServletConfigurations()) {
            for (ServletConfiguration servlet : this.webappConfig.getServletConfigurations()) {
                servlet.init();
            }
        }
    }

    public FilterChainImpl initializeChain(String uri) {
        ServletConfiguration servletConfiguration = this.findServlet(uri);
        FilterChainImpl chain = new FilterChainImpl(servletConfiguration);
        if (this.webappConfig.hasFilterConfigurations()) {
            for (FilterConfiguration s : this.webappConfig.getFilterConfigurations()) {
                if (!s.matchesUrlPattern(uri)) continue;
                chain.addFilterConfiguration(s);
            }
        }
        return chain;
    }

    private ServletConfiguration findServlet(String uri) {
        if (!this.webappConfig.hasServletConfigurations()) {
            return null;
        }
        for (ServletConfiguration s : this.webappConfig.getServletConfigurations()) {
            if (!s.matchesUrlPattern(uri)) continue;
            return s;
        }
        return null;
    }

    public File getStaticResourcesFolder() {
        return this.webappConfig.getStaticResourcesFolder();
    }

    public WebappConfiguration getWebappConfig() {
        return this.webappConfig;
    }

    public ChannelGroup getSharedChannelGroup() {
        return this.sharedChannelGroup;
    }
}

