/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.impl;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.javaforge.netty.servlet.bridge.impl.ConfigAdapter;
import net.javaforge.netty.servlet.bridge.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextImpl
extends ConfigAdapter
implements ServletContext {
    private static final Logger log = LoggerFactory.getLogger(ServletContextImpl.class);
    private static ServletContextImpl instance;
    private Map<String, Object> attributes;
    private String servletContextName;

    public static final ServletContextImpl get() {
        if (instance == null) {
            instance = new ServletContextImpl();
        }
        return instance;
    }

    private ServletContextImpl() {
        super("Netty Servlet Bridge");
    }

    public Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    public Enumeration getAttributeNames() {
        return Utils.enumerationFromKeys(this.attributes);
    }

    public String getContextPath() {
        return "";
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public URL getResource(String path) throws MalformedURLException {
        return ServletContextImpl.class.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return ServletContextImpl.class.getResourceAsStream(path);
    }

    public String getServerInfo() {
        return super.getOwnerName();
    }

    public void log(String msg) {
        log.info(msg);
    }

    public void log(Exception exception, String msg) {
        log.error(msg, (Throwable)exception);
    }

    public void log(String message, Throwable throwable) {
        log.error(message, throwable);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, object);
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new IllegalStateException("Deprecated as of Java Servlet API 2.1, with no direct replacement!");
    }

    public Enumeration getServletNames() {
        throw new IllegalStateException("Method 'getServletNames' deprecated as of Java Servlet API 2.0, with no replacement.");
    }

    public Enumeration getServlets() {
        throw new IllegalStateException("Method 'getServlets' deprecated as of Java Servlet API 2.0, with no replacement.");
    }

    public ServletContext getContext(String uripath) {
        return this;
    }

    public String getMimeType(String file) {
        return Utils.getMimeType(file);
    }

    public Set getResourcePaths(String path) {
        throw new IllegalStateException("Method 'getResourcePaths' not yet implemented!");
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new IllegalStateException("Method 'getNamedDispatcher' not yet implemented!");
    }

    public String getRealPath(String path) {
        throw new IllegalStateException("Method 'getRealPath' not yet implemented!");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new IllegalStateException("Method 'getRequestDispatcher' not yet implemented!");
    }
}

