/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.impl;

import net.javaforge.netty.servlet.bridge.impl.FilterChainImpl;

public class URIParser {
    private FilterChainImpl chain;
    private String servletPath;
    private String requestUri;
    private String pathInfo;
    private String queryString;

    public URIParser(FilterChainImpl chain) {
        this.chain = chain;
    }

    public void parse(String uri) {
        int indx = uri.indexOf(63);
        this.servletPath = this.chain.getServletConfiguration().getMatchingUrlPattern(uri);
        if (!this.servletPath.startsWith("/")) {
            this.servletPath = "/" + this.servletPath;
        }
        if (indx != -1) {
            this.pathInfo = uri.substring(this.servletPath.length(), indx);
            this.queryString = uri.substring(indx + 1);
            this.requestUri = uri.substring(0, indx);
        } else {
            this.pathInfo = uri.substring(this.servletPath.length());
            this.requestUri = uri;
        }
        if (this.requestUri.endsWith("/")) {
            this.requestUri.substring(0, this.requestUri.length() - 1);
        }
        if (this.pathInfo.equals("")) {
            this.pathInfo = null;
        } else if (!this.pathInfo.startsWith("/")) {
            this.pathInfo = "/" + this.pathInfo;
        }
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getRequestUri() {
        return this.requestUri;
    }
}

