/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.interceptor;

import java.util.Collection;
import net.javaforge.netty.servlet.bridge.HttpSessionThreadLocal;
import net.javaforge.netty.servlet.bridge.ServletBridgeInterceptor;
import net.javaforge.netty.servlet.bridge.impl.HttpSessionImpl;
import net.javaforge.netty.servlet.bridge.session.ServletBridgeHttpSessionStore;
import net.javaforge.netty.servlet.bridge.util.Utils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class HttpSessionInterceptor
implements ServletBridgeInterceptor {
    private boolean sessionRequestedByCookie = false;

    public HttpSessionInterceptor(ServletBridgeHttpSessionStore sessionStore) {
        HttpSessionThreadLocal.setSessionStore(sessionStore);
    }

    public void onRequestReceived(ChannelHandlerContext ctx, MessageEvent e) {
        HttpSessionThreadLocal.unset();
        HttpRequest request = (HttpRequest)e.getMessage();
        Collection<Cookie> cookies = Utils.getCookies("JSESSIONID", request);
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String jsessionId = cookie.getValue();
                HttpSessionImpl s = HttpSessionThreadLocal.getSessionStore().findSession(jsessionId);
                if (s == null) continue;
                HttpSessionThreadLocal.set(s);
                this.sessionRequestedByCookie = true;
                break;
            }
        }
    }

    public void onRequestSuccessed(ChannelHandlerContext ctx, MessageEvent e, HttpResponse response) {
        HttpSessionImpl s = HttpSessionThreadLocal.get();
        if (s != null && !this.sessionRequestedByCookie) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            cookieEncoder.addCookie("JSESSIONID", s.getId());
            HttpHeaders.addHeader((HttpMessage)response, (String)"Set-Cookie", (Object)cookieEncoder.encode());
        }
    }

    public void onRequestFailed(ChannelHandlerContext ctx, ExceptionEvent e, HttpResponse response) {
        this.sessionRequestedByCookie = false;
        HttpSessionThreadLocal.unset();
    }
}

