/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.session;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.javaforge.netty.servlet.bridge.impl.HttpSessionImpl;
import net.javaforge.netty.servlet.bridge.session.ServletBridgeHttpSessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServletBridgeHttpSessionStore
implements ServletBridgeHttpSessionStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultServletBridgeHttpSessionStore.class);
    public static ConcurrentHashMap<String, HttpSessionImpl> sessions = new ConcurrentHashMap();

    public HttpSessionImpl createSession() {
        String sessionId = this.generateNewSessionId();
        log.debug("Creating new session with id {}", (Object)sessionId);
        HttpSessionImpl session = new HttpSessionImpl(sessionId);
        sessions.put(sessionId, session);
        return session;
    }

    public void destroySession(String sessionId) {
        log.debug("Destroying session with id {}", (Object)sessionId);
        sessions.remove(sessionId);
    }

    public HttpSessionImpl findSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return sessions.get(sessionId);
    }

    protected String generateNewSessionId() {
        return UUID.randomUUID().toString();
    }

    public void destroyInactiveSessions() {
        for (Map.Entry<String, HttpSessionImpl> entry : sessions.entrySet()) {
            long currentMillis;
            HttpSessionImpl session = entry.getValue();
            if (session.getMaxInactiveInterval() < 0 || (currentMillis = System.currentTimeMillis()) - session.getLastAccessedTime() <= (long)(session.getMaxInactiveInterval() * 1000)) continue;
            this.destroySession(entry.getKey());
        }
    }
}

