/*
 * Decompiled with CFR 0.152.
 */
package net.javaforge.netty.servlet.bridge.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.javaforge.netty.servlet.bridge.ServletBridgeRuntimeException;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private Utils() {
    }

    public static final <T> Enumeration<T> emptyEnumeration() {
        return Collections.enumeration(Collections.emptySet());
    }

    public static final <T> Enumeration<T> enumeration(Collection<T> collection) {
        if (collection == null) {
            return Utils.emptyEnumeration();
        }
        return Collections.enumeration(collection);
    }

    public static final <T> Enumeration<T> enumerationFromKeys(Map<T, ?> map) {
        if (map == null) {
            return Utils.emptyEnumeration();
        }
        return Collections.enumeration(map.keySet());
    }

    public static final <T> Enumeration<T> enumerationFromValues(Map<?, T> map) {
        if (map == null) {
            return Utils.emptyEnumeration();
        }
        return Collections.enumeration(map.values());
    }

    public static final <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ServletBridgeRuntimeException("Error instantiating class: " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new ServletBridgeRuntimeException("Error instantiating class: " + clazz, e);
        }
    }

    public static final String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public static final Collection<Cookie> getCookies(String name, HttpRequest request) {
        String cookieString = request.getHeader("Cookie");
        if (cookieString != null) {
            ArrayList<Cookie> foundCookie = new ArrayList<Cookie>();
            CookieDecoder cookieDecoder = new CookieDecoder();
            Set cookies = cookieDecoder.decode(cookieString);
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                foundCookie.add(cookie);
            }
            return foundCookie;
        }
        return null;
    }

    public static final Collection<Cookie> getCookies(String name, HttpResponse response) {
        String cookieString = response.getHeader("Cookie");
        if (cookieString != null) {
            ArrayList<Cookie> foundCookie = new ArrayList<Cookie>();
            CookieDecoder cookieDecoder = new CookieDecoder();
            Set cookies = cookieDecoder.decode(cookieString);
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                foundCookie.add(cookie);
            }
            return foundCookie;
        }
        return null;
    }

    public static final String getMimeType(String fileUrl) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(fileUrl);
        return type;
    }

    public static final String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        uri = uri.replace('/', File.separatorChar);
        if (uri.contains(File.separator + ".") || uri.contains("." + File.separator) || uri.startsWith(".") || uri.endsWith(".")) {
            return null;
        }
        return uri;
    }

    public static final Collection<Locale> parseAcceptLanguageHeader(String acceptLanguageHeader) {
        if (acceptLanguageHeader == null) {
            return null;
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String str : acceptLanguageHeader.split(",")) {
            String[] arr = str.trim().replace("-", "_").split(";");
            Locale locale = null;
            String[] l = arr[0].split("_");
            switch (l.length) {
                case 2: {
                    locale = new Locale(l[0], l[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(l[0], l[1], l[2]);
                    break;
                }
                default: {
                    locale = new Locale(l[0]);
                }
            }
            locales.add(locale);
        }
        return locales;
    }
}

