/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client;

import com.auth0.utils.Asserts;
import java.net.Proxy;
import okhttp3.Credentials;

public class ProxyOptions {
    private final Proxy proxy;
    private String basicAuth;

    public ProxyOptions(Proxy proxy) {
        Asserts.assertNotNull(proxy, "proxy");
        this.proxy = proxy;
    }

    public void setBasicAuthentication(String username, char[] password) {
        Asserts.assertNotNull(this.proxy, "username");
        Asserts.assertNotNull(this.proxy, "password");
        this.basicAuth = Credentials.basic(username, new String(password));
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getBasicAuthentication() {
        return this.basicAuth;
    }
}

