/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.attackprotection.BreachedPassword;
import com.auth0.json.mgmt.attackprotection.BruteForceConfiguration;
import com.auth0.json.mgmt.attackprotection.SuspiciousIPThrottlingConfiguration;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class AttackProtectionEntity
extends BaseManagementEntity {
    AttackProtectionEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<BreachedPassword> getBreachedPasswordSettings() {
        return this.request(HttpMethod.GET, new TypeReference<BreachedPassword>(){}, builder -> builder.withPathSegments("api/v2/attack-protection/breached-password-detection"));
    }

    public Request<BreachedPassword> updateBreachedPasswordSettings(BreachedPassword breachedPassword) {
        Asserts.assertNotNull(breachedPassword, "breached password");
        return this.request(HttpMethod.PATCH, new TypeReference<BreachedPassword>(){}, builder -> builder.withPathSegments("api/v2/attack-protection/breached-password-detection").withBody(breachedPassword));
    }

    public Request<BruteForceConfiguration> getBruteForceConfiguration() {
        return this.request(HttpMethod.GET, new TypeReference<BruteForceConfiguration>(){}, builder -> builder.withPathSegments("api/v2/attack-protection/brute-force-protection"));
    }

    public Request<BruteForceConfiguration> updateBruteForceConfiguration(BruteForceConfiguration configuration) {
        Asserts.assertNotNull(configuration, "configuration");
        return this.request(HttpMethod.PATCH, new TypeReference<BruteForceConfiguration>(){}, builder -> builder.withPathSegments("api/v2/attack-protection/brute-force-protection").withBody(configuration));
    }

    public Request<SuspiciousIPThrottlingConfiguration> getSuspiciousIPThrottlingConfiguration() {
        return this.request(HttpMethod.GET, new TypeReference<SuspiciousIPThrottlingConfiguration>(){}, builder -> builder.withPathSegments("api/v2/attack-protection/suspicious-ip-throttling"));
    }

    public Request<SuspiciousIPThrottlingConfiguration> updateSuspiciousIPThrottlingConfiguration(SuspiciousIPThrottlingConfiguration configuration) {
        Asserts.assertNotNull(configuration, "configuration");
        return this.request(HttpMethod.PATCH, new TypeReference<SuspiciousIPThrottlingConfiguration>(){}, builder -> builder.withPathSegments("api/v2/attack-protection/suspicious-ip-throttling").withBody(configuration));
    }
}

