/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.blacklists.Token;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.List;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class BlacklistsEntity
extends BaseManagementEntity {
    BlacklistsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<List<Token>> getBlacklist(String audience) {
        Asserts.assertNotNull(audience, "audience");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/blacklists/tokens").addQueryParameter("aud", audience).build().toString();
        return new BaseRequest<List<Token>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<Token>>(){});
    }

    public Request<Void> blacklistToken(Token token) {
        Asserts.assertNotNull(token, "token");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/blacklists/tokens").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.POST);
        request.setBody(token);
        return request;
    }
}

