/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.branding.BrandingSettings;
import com.auth0.json.mgmt.branding.UniversalLoginTemplate;
import com.auth0.json.mgmt.branding.UniversalLoginTemplateUpdate;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class BrandingEntity
extends BaseManagementEntity {
    BrandingEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<BrandingSettings> getBrandingSettings() {
        return this.request(HttpMethod.GET, new TypeReference<BrandingSettings>(){}, builder -> builder.withPathSegments("api/v2/branding"));
    }

    public Request<BrandingSettings> updateBrandingSettings(BrandingSettings settings) {
        Asserts.assertNotNull(settings, "settings");
        return this.request(HttpMethod.PATCH, new TypeReference<BrandingSettings>(){}, builder -> builder.withPathSegments("api/v2/branding").withBody(settings));
    }

    public Request<UniversalLoginTemplate> getUniversalLoginTemplate() {
        return this.request(HttpMethod.GET, new TypeReference<UniversalLoginTemplate>(){}, builder -> builder.withPathSegments("api/v2/branding/templates/universal-login"));
    }

    public Request<Void> deleteUniversalLoginTemplate() {
        return this.voidRequest(HttpMethod.DELETE, builder -> builder.withPathSegments("api/v2/branding/templates/universal-login"));
    }

    public Request<Void> setUniversalLoginTemplate(UniversalLoginTemplateUpdate template) {
        Asserts.assertNotNull(template, "template");
        return this.voidRequest(HttpMethod.PUT, builder -> builder.withPathSegments("api/v2/branding/templates/universal-login").withBody(template));
    }
}

