/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.HttpOptions;
import com.auth0.client.mgmt.ActionsEntity;
import com.auth0.client.mgmt.AttackProtectionEntity;
import com.auth0.client.mgmt.BlacklistsEntity;
import com.auth0.client.mgmt.BrandingEntity;
import com.auth0.client.mgmt.ClientGrantsEntity;
import com.auth0.client.mgmt.ClientsEntity;
import com.auth0.client.mgmt.ConnectionsEntity;
import com.auth0.client.mgmt.DeviceCredentialsEntity;
import com.auth0.client.mgmt.EmailProviderEntity;
import com.auth0.client.mgmt.EmailTemplatesEntity;
import com.auth0.client.mgmt.GrantsEntity;
import com.auth0.client.mgmt.GuardianEntity;
import com.auth0.client.mgmt.JobsEntity;
import com.auth0.client.mgmt.KeysEntity;
import com.auth0.client.mgmt.LogEventsEntity;
import com.auth0.client.mgmt.LogStreamsEntity;
import com.auth0.client.mgmt.OrganizationsEntity;
import com.auth0.client.mgmt.ResourceServerEntity;
import com.auth0.client.mgmt.RolesEntity;
import com.auth0.client.mgmt.RulesConfigsEntity;
import com.auth0.client.mgmt.RulesEntity;
import com.auth0.client.mgmt.SimpleTokenProvider;
import com.auth0.client.mgmt.StatsEntity;
import com.auth0.client.mgmt.TenantsEntity;
import com.auth0.client.mgmt.TicketsEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.UserBlocksEntity;
import com.auth0.client.mgmt.UsersEntity;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.DefaultHttpClient;
import com.auth0.utils.Asserts;
import okhttp3.HttpUrl;

public class ManagementAPI {
    private final HttpUrl baseUrl;
    private TokenProvider tokenProvider;
    private final Auth0HttpClient client;

    @Deprecated
    public ManagementAPI(String domain, String apiToken, HttpOptions options) {
        this(domain, SimpleTokenProvider.create(apiToken), ManagementAPI.buildNetworkingClient(options));
    }

    @Deprecated
    public ManagementAPI(String domain, String apiToken) {
        this(domain, SimpleTokenProvider.create(apiToken), DefaultHttpClient.newBuilder().build());
    }

    public static Builder newBuilder(String domain, String apiToken) {
        return new Builder(domain, apiToken);
    }

    private ManagementAPI(String domain, TokenProvider tokenProvider, Auth0HttpClient httpClient) {
        Asserts.assertNotNull(domain, "domain");
        Asserts.assertNotNull(tokenProvider, "token provider");
        this.baseUrl = this.createBaseUrl(domain);
        if (this.baseUrl == null) {
            throw new IllegalArgumentException("The domain had an invalid format and couldn't be parsed as an URL.");
        }
        this.tokenProvider = tokenProvider;
        this.client = httpClient;
    }

    private static DefaultHttpClient buildNetworkingClient(HttpOptions options) {
        Asserts.assertNotNull(options, "Http options");
        return DefaultHttpClient.newBuilder().withLogging(options.getLoggingOptions()).withMaxRetries(options.getManagementAPIMaxRetries()).withMaxRequests(options.getMaxRequests()).withMaxRequestsPerHost(options.getMaxRequestsPerHost()).withProxy(options.getProxyOptions()).withConnectTimeout(options.getConnectTimeout()).withReadTimeout(options.getReadTimeout()).build();
    }

    public void setApiToken(String apiToken) {
        Asserts.assertNotNull(apiToken, "api token");
        this.tokenProvider = SimpleTokenProvider.create(apiToken);
    }

    Auth0HttpClient getHttpClient() {
        return this.client;
    }

    HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    private HttpUrl createBaseUrl(String domain) {
        String url = domain;
        if (!domain.startsWith("https://") && !domain.startsWith("http://")) {
            url = "https://" + domain;
        }
        return HttpUrl.parse(url);
    }

    public BrandingEntity branding() {
        return new BrandingEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public ClientGrantsEntity clientGrants() {
        return new ClientGrantsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public ClientsEntity clients() {
        return new ClientsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public ConnectionsEntity connections() {
        return new ConnectionsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public DeviceCredentialsEntity deviceCredentials() {
        return new DeviceCredentialsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public GrantsEntity grants() {
        return new GrantsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public LogEventsEntity logEvents() {
        return new LogEventsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public LogStreamsEntity logStreams() {
        return new LogStreamsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public RulesEntity rules() {
        return new RulesEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public RulesConfigsEntity rulesConfigs() {
        return new RulesConfigsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public UserBlocksEntity userBlocks() {
        return new UserBlocksEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public UsersEntity users() {
        return new UsersEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public BlacklistsEntity blacklists() {
        return new BlacklistsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public EmailTemplatesEntity emailTemplates() {
        return new EmailTemplatesEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public EmailProviderEntity emailProvider() {
        return new EmailProviderEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public GuardianEntity guardian() {
        return new GuardianEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public StatsEntity stats() {
        return new StatsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public TenantsEntity tenants() {
        return new TenantsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public TicketsEntity tickets() {
        return new TicketsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public ResourceServerEntity resourceServers() {
        return new ResourceServerEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public JobsEntity jobs() {
        return new JobsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public RolesEntity roles() {
        return new RolesEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public OrganizationsEntity organizations() {
        return new OrganizationsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public ActionsEntity actions() {
        return new ActionsEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public AttackProtectionEntity attackProtection() {
        return new AttackProtectionEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public KeysEntity keys() {
        return new KeysEntity(this.client, this.baseUrl, this.tokenProvider);
    }

    public static class Builder {
        private final String domain;
        private final String apiToken;
        private Auth0HttpClient httpClient = DefaultHttpClient.newBuilder().build();

        public Builder(String domain, String apiToken) {
            this.domain = domain;
            this.apiToken = apiToken;
        }

        public Builder withHttpClient(Auth0HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public ManagementAPI build() {
            return new ManagementAPI(this.domain, SimpleTokenProvider.create(this.apiToken), this.httpClient);
        }
    }
}

