/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.TokenProvider;
import com.auth0.utils.Asserts;
import java.util.concurrent.CompletableFuture;

public class SimpleTokenProvider
implements TokenProvider {
    private final String apiToken;

    public static SimpleTokenProvider create(String apiToken) {
        return new SimpleTokenProvider(apiToken);
    }

    @Override
    public String getToken() {
        return this.apiToken;
    }

    @Override
    public CompletableFuture<String> getTokenAsync() {
        return CompletableFuture.supplyAsync(() -> this.apiToken);
    }

    private SimpleTokenProvider(String apiToken) {
        Asserts.assertNotNull(apiToken, "api token");
        this.apiToken = apiToken;
    }
}

