/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.json.mgmt.tenants.Tenant;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class TenantsEntity
extends BaseManagementEntity {
    TenantsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<Tenant> get(FieldsFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/tenants/settings");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<Tenant>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Tenant>(){});
    }

    public Request<Tenant> update(Tenant tenant) {
        Asserts.assertNotNull(tenant, "tenant");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/tenants/settings").build().toString();
        BaseRequest<Tenant> request = new BaseRequest<Tenant>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<Tenant>(){});
        request.setBody(tenant);
        return request;
    }
}

