/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.tickets.EmailVerificationTicket;
import com.auth0.json.mgmt.tickets.PasswordChangeTicket;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class TicketsEntity
extends BaseManagementEntity {
    TicketsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<EmailVerificationTicket> requestEmailVerification(EmailVerificationTicket emailVerificationTicket) {
        Asserts.assertNotNull(emailVerificationTicket, "email verification ticket");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/tickets/email-verification").build().toString();
        BaseRequest<EmailVerificationTicket> request = new BaseRequest<EmailVerificationTicket>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<EmailVerificationTicket>(){});
        request.setBody(emailVerificationTicket);
        return request;
    }

    public Request<PasswordChangeTicket> requestPasswordChange(PasswordChangeTicket passwordChangeTicket) {
        Asserts.assertNotNull(passwordChangeTicket, "password change ticket");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/tickets/password-change").build().toString();
        BaseRequest<PasswordChangeTicket> request = new BaseRequest<PasswordChangeTicket>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<PasswordChangeTicket>(){});
        request.setBody(passwordChangeTicket);
        return request;
    }
}

