/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.exception;

import com.auth0.exception.Auth0Exception;
import com.auth0.exception.PasswordStrengthErrorParser;
import java.util.Collections;
import java.util.Map;

public class APIException
extends Auth0Exception {
    private static final String ERROR_DESCRIPTION = "error_description";
    private static final String DESCRIPTION = "description";
    private static final String MESSAGE = "message";
    private static final String ERROR = "error";
    private static final String ERROR_CODE = "errorCode";
    private static final String CODE = "code";
    private String error;
    private final String description;
    private final int statusCode;
    private Map<String, Object> values;

    public APIException(String payload, int statusCode, Throwable cause) {
        super(APIException.createMessage(payload, statusCode), cause);
        this.description = payload;
        this.statusCode = statusCode;
    }

    public APIException(Map<String, Object> values2, int statusCode) {
        super(APIException.createMessage(APIException.obtainExceptionMessage(values2), statusCode));
        this.values = Collections.unmodifiableMap(values2);
        this.error = APIException.obtainExceptionError(this.values);
        this.description = APIException.obtainExceptionMessage(this.values);
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getError() {
        return this.error;
    }

    public Object getValue(String key) {
        if (this.values == null) {
            return null;
        }
        return this.values.get(key);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isMultifactorRequired() {
        return "mfa_required".equals(this.error);
    }

    public boolean isInvalidCredentials() {
        return "invalid_user_password".equals(this.error) || "invalid_grant".equals(this.error) && "Wrong email or password.".equals(this.description);
    }

    public boolean isMultifactorEnrollRequired() {
        return "unsupported_challenge_type".equals(this.error);
    }

    public boolean isVerificationRequired() {
        return "requires_verification".equals(this.error);
    }

    public boolean isMultifactorTokenInvalid() {
        return "expired_token".equals(this.error) && "mfa_token is expired".equals(this.description) || "invalid_grant".equals(this.error) && "Malformed mfa_token".equals(this.description);
    }

    public boolean isAccessDenied() {
        return "access_denied".equals(this.error);
    }

    private static String createMessage(String description, int statusCode) {
        return String.format("Request failed with status code %d: %s", statusCode, description);
    }

    private static String obtainExceptionMessage(Map<String, Object> values2) {
        if (values2.containsKey(ERROR_DESCRIPTION)) {
            return APIException.toStringOrNull(values2.get(ERROR_DESCRIPTION));
        }
        if (values2.containsKey(DESCRIPTION)) {
            Object description = values2.get(DESCRIPTION);
            if (description instanceof String) {
                return (String)description;
            }
            if (description instanceof Map) {
                PasswordStrengthErrorParser policy = new PasswordStrengthErrorParser((Map)description);
                return policy.getDescription();
            }
        }
        if (values2.containsKey(MESSAGE)) {
            return APIException.toStringOrNull(values2.get(MESSAGE));
        }
        if (values2.containsKey(ERROR)) {
            return APIException.toStringOrNull(values2.get(ERROR));
        }
        return "Unknown exception";
    }

    private static String obtainExceptionError(Map<String, Object> values2) {
        if (values2.containsKey(ERROR_CODE)) {
            return APIException.toStringOrNull(values2.get(ERROR_CODE));
        }
        if (values2.containsKey(ERROR)) {
            return APIException.toStringOrNull(values2.get(ERROR));
        }
        if (values2.containsKey(CODE)) {
            return APIException.toStringOrNull(values2.get(CODE));
        }
        return "Unknown error";
    }

    private static String toStringOrNull(Object obj) {
        return obj != null ? obj.toString() : null;
    }
}

