/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.impl.JsonNodeClaim;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.Payload;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import wiremock.com.fasterxml.jackson.core.ObjectCodec;
import wiremock.com.fasterxml.jackson.databind.JsonNode;

class PayloadImpl
implements Payload,
Serializable {
    private static final long serialVersionUID = 1659021498824562311L;
    private final String issuer;
    private final String subject;
    private final List<String> audience;
    private final Instant expiresAt;
    private final Instant notBefore;
    private final Instant issuedAt;
    private final String jwtId;
    private final Map<String, JsonNode> tree;
    private final ObjectCodec objectCodec;

    PayloadImpl(String issuer, String subject, List<String> audience, Instant expiresAt, Instant notBefore, Instant issuedAt, String jwtId, Map<String, JsonNode> tree, ObjectCodec objectCodec) {
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience != null ? Collections.unmodifiableList(audience) : null;
        this.expiresAt = expiresAt;
        this.notBefore = notBefore;
        this.issuedAt = issuedAt;
        this.jwtId = jwtId;
        this.tree = tree != null ? Collections.unmodifiableMap(tree) : Collections.emptyMap();
        this.objectCodec = objectCodec;
    }

    Map<String, JsonNode> getTree() {
        return this.tree;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public List<String> getAudience() {
        return this.audience;
    }

    @Override
    public Date getExpiresAt() {
        return this.expiresAt != null ? Date.from(this.expiresAt) : null;
    }

    @Override
    public Instant getExpiresAtAsInstant() {
        return this.expiresAt;
    }

    @Override
    public Date getIssuedAt() {
        return this.issuedAt != null ? Date.from(this.issuedAt) : null;
    }

    @Override
    public Instant getIssuedAtAsInstant() {
        return this.issuedAt;
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore != null ? Date.from(this.notBefore) : null;
    }

    @Override
    public Instant getNotBeforeAsInstant() {
        return this.notBefore;
    }

    @Override
    public String getId() {
        return this.jwtId;
    }

    @Override
    public Claim getClaim(String name) {
        return JsonNodeClaim.extractClaim(name, this.tree, this.objectCodec);
    }

    @Override
    public Map<String, Claim> getClaims() {
        HashMap<String, Claim> claims = new HashMap<String, Claim>(this.tree.size() * 2);
        for (String name : this.tree.keySet()) {
            claims.put(name, JsonNodeClaim.extractClaim(name, this.tree, this.objectCodec));
        }
        return Collections.unmodifiableMap(claims);
    }
}

