/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.ObjectMapperProvider;
import com.auth0.net.BaseRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.Auth0HttpResponse;
import com.auth0.net.client.Auth0MultipartRequestBody;
import com.auth0.net.client.HttpMethod;
import com.auth0.net.client.HttpRequestBody;
import com.auth0.utils.Asserts;
import java.io.File;
import java.io.IOException;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;

public class MultipartRequest<T>
extends BaseRequest<T> {
    private static final String CONTENT_TYPE_FORM_DATA = "multipart/form-data";
    private final Auth0MultipartRequestBody.Builder bodyBuilder;
    private final TypeReference<T> tType;
    private final ObjectMapper mapper;
    private int partsCount;

    MultipartRequest(Auth0HttpClient client, TokenProvider tokenProvider, String url, HttpMethod method, ObjectMapper mapper, TypeReference<T> tType) {
        super(client, tokenProvider, url, method, mapper, tType);
        if (HttpMethod.GET.equals((Object)method)) {
            throw new IllegalArgumentException("Multipart/form-data requests do not support the GET method.");
        }
        this.mapper = mapper;
        this.tType = tType;
        this.bodyBuilder = Auth0MultipartRequestBody.newBuilder();
    }

    public MultipartRequest(Auth0HttpClient client, TokenProvider tokenProvider, String url, HttpMethod method, TypeReference<T> tType) {
        this(client, tokenProvider, url, method, ObjectMapperProvider.getMapper(), tType);
    }

    @Override
    protected String getContentType() {
        return CONTENT_TYPE_FORM_DATA;
    }

    @Override
    protected HttpRequestBody createRequestBody() throws IOException {
        if (this.partsCount == 0) {
            throw new IOException("Cannot create multipart/form-data request body with zero parts.");
        }
        return HttpRequestBody.create("application/json", this.bodyBuilder.build());
    }

    @Override
    protected T readResponseBody(Auth0HttpResponse response) throws IOException {
        String payload = response.getBody();
        return this.mapper.readValue(payload, this.tType);
    }

    @Override
    public MultipartRequest<T> addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    public MultipartRequest<T> addPart(String name, File file, String mediaType) {
        Asserts.assertNotNull(name, "name");
        Asserts.assertNotNull(name, "file");
        if (!file.exists()) {
            throw new IllegalArgumentException("Failed to add part because the file specified cannot be found.");
        }
        this.bodyBuilder.withFilePart(new Auth0MultipartRequestBody.FilePart(name, file, mediaType));
        ++this.partsCount;
        return this;
    }

    public MultipartRequest<T> addPart(String name, String value) {
        Asserts.assertNotNull(name, "name");
        Asserts.assertNotNull(value, "value");
        this.bodyBuilder.withPart(name, value);
        ++this.partsCount;
        return this;
    }
}

