/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.json.ObjectMapperProvider;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;

public class Telemetry {
    static final String HEADER_NAME = "Auth0-Client";
    private static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";
    private static final String LIBRARY_VERSION_KEY = "auth0-java";
    private static final String ENV_KEY = "env";
    private static final String JAVA_KEY = "java";
    private final String name;
    private final String version;
    private final String libraryVersion;
    private final Map<String, String> env;
    private final String value;

    public Telemetry(String name, String version) {
        this(name, version, null);
    }

    public Telemetry(String name, String version, String libraryVersion) {
        String tmpValue;
        this.name = name;
        this.version = version;
        this.libraryVersion = libraryVersion;
        if (name == null) {
            this.env = Collections.emptyMap();
            this.value = null;
            return;
        }
        HashMap<String, Object> values2 = new HashMap<String, Object>();
        values2.put(NAME_KEY, name);
        if (version != null) {
            values2.put(VERSION_KEY, version);
        }
        HashMap<String, String> tmpEnv = new HashMap<String, String>();
        tmpEnv.put(JAVA_KEY, this.getJDKVersion());
        if (libraryVersion != null) {
            tmpEnv.put(LIBRARY_VERSION_KEY, libraryVersion);
        }
        this.env = Collections.unmodifiableMap(tmpEnv);
        values2.put(ENV_KEY, this.env);
        try {
            String json = ObjectMapperProvider.getMapper().writeValueAsString(values2);
            tmpValue = Base64.getUrlEncoder().encodeToString(json.getBytes());
        }
        catch (JsonProcessingException e) {
            tmpValue = null;
            e.printStackTrace();
        }
        this.value = tmpValue;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    String getLibraryVersion() {
        return this.libraryVersion;
    }

    Map<String, String> getEnvironment() {
        return this.env;
    }

    public String getValue() {
        return this.value;
    }

    private String getJDKVersion() {
        String version;
        try {
            version = System.getProperty(JAVA_SPECIFICATION_VERSION);
        }
        catch (Exception ignored) {
            version = Runtime.class.getPackage().getSpecificationVersion();
        }
        return version;
    }
}

