/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

class CompositeTrustManager
extends X509ExtendedTrustManager {
    private final List<X509ExtendedTrustManager> trustManagers;
    private final X509Certificate[] acceptedIssuers;

    CompositeTrustManager(List<X509ExtendedTrustManager> trustManagers) {
        if (trustManagers.isEmpty()) {
            throw new IllegalArgumentException("A trust manager must be provided");
        }
        this.trustManagers = new ArrayList<X509ExtendedTrustManager>(trustManagers);
        this.acceptedIssuers = this.loadAcceptedIssuers(this.trustManagers);
    }

    private X509Certificate[] loadAcceptedIssuers(List<X509ExtendedTrustManager> trustManagers) {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (X509TrustManager x509TrustManager : trustManagers) {
            result.addAll(Arrays.asList(x509TrustManager.getAcceptedIssuers()));
        }
        return result.toArray(new X509Certificate[0]);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkAllTrustManagers(tm -> tm.checkClientTrusted(chain, authType));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkAllTrustManagers(tm -> tm.checkServerTrusted(chain, authType));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkAllTrustManagers(tm -> tm.checkClientTrusted(chain, authType, socket));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.checkAllTrustManagers(tm -> tm.checkServerTrusted(chain, authType, socket));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkAllTrustManagers(tm -> tm.checkClientTrusted(chain, authType, engine));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkAllTrustManagers(tm -> tm.checkServerTrusted(chain, authType, engine));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return Arrays.copyOf(this.acceptedIssuers, this.acceptedIssuers.length);
    }

    private void checkAllTrustManagers(CertificateChecker certificateChecker) throws CertificateException {
        Iterator<X509ExtendedTrustManager> iterator2 = this.trustManagers.iterator();
        while (iterator2.hasNext()) {
            X509ExtendedTrustManager tm = iterator2.next();
            try {
                certificateChecker.check(tm);
                break;
            }
            catch (CertificateException e) {
                if (iterator2.hasNext()) continue;
                throw e;
            }
        }
    }

    private static interface CertificateChecker {
        public void check(X509ExtendedTrustManager var1) throws CertificateException;
    }
}

