/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePatternDeserializer;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.SingleMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(using=MultiValuePatternDeserializer.class)
public abstract class MultiValuePattern
implements NamedValueMatcher<MultiValue> {
    public static MultiValuePattern of(StringValuePattern valuePattern) {
        return new SingleMatchMultiValuePattern(valuePattern);
    }

    public static MultiValuePattern absent() {
        return new SingleMatchMultiValuePattern(WireMock.absent());
    }

    protected static MatchResult getBestMatch(StringValuePattern valuePattern, List<String> values2) {
        List allResults = values2.stream().map(valuePattern::match).collect(Collectors.toList());
        return Collections.min(allResults, Comparator.comparingDouble(MatchResult::getDistance));
    }
}

