/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonValue;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(as=SingleMatchMultiValuePattern.class)
public class SingleMatchMultiValuePattern
extends MultiValuePattern {
    private final StringValuePattern valuePattern;

    @JsonCreator
    public SingleMatchMultiValuePattern(StringValuePattern valuePattern) {
        this.valuePattern = valuePattern;
    }

    @Override
    public MatchResult match(MultiValue multiValue) {
        List<String> values2 = multiValue.isPresent() ? multiValue.values() : Collections.singletonList(null);
        return SingleMatchMultiValuePattern.getBestMatch(this.valuePattern, values2);
    }

    @JsonValue
    public StringValuePattern getValuePattern() {
        return this.valuePattern;
    }

    @Override
    public String getName() {
        return this.valuePattern.getName();
    }

    @Override
    public String getExpected() {
        return this.valuePattern.getExpected();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleMatchMultiValuePattern that = (SingleMatchMultiValuePattern)o;
        return Objects.equals(this.valuePattern, that.valuePattern);
    }

    public int hashCode() {
        return Objects.hash(this.valuePattern);
    }
}

