/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.Timeout;
import net.jodah.failsafe.TimeoutExceededException;
import net.jodah.failsafe.util.concurrent.Scheduler;

class TimeoutExecutor<R>
extends PolicyExecutor<R, Timeout<R>> {
    TimeoutExecutor(Timeout<R> timeout2, AbstractExecution<R> execution) {
        super(timeout2, execution);
    }

    @Override
    protected boolean isFailure(ExecutionResult result) {
        boolean timeoutExceeded = this.execution.isAsyncExecution() && this.execution.getElapsedAttemptTime().toNanos() >= ((Timeout)this.policy).getTimeout().toNanos();
        return timeoutExceeded || !result.isNonResult() && result.getFailure() instanceof TimeoutExceededException;
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        if (!(result.getFailure() instanceof TimeoutExceededException)) {
            result = ExecutionResult.failure(new TimeoutExceededException((Timeout)this.policy));
        }
        return result;
    }

    @Override
    protected Supplier<ExecutionResult> supply(Supplier<ExecutionResult> supplier, Scheduler scheduler) {
        return () -> {
            ScheduledFuture<?> timeoutFuture;
            AtomicReference result = new AtomicReference();
            Thread executionThread = Thread.currentThread();
            try {
                timeoutFuture = Scheduler.DEFAULT.schedule(() -> {
                    if (result.compareAndSet(null, ExecutionResult.failure(new TimeoutExceededException((Timeout)this.policy)))) {
                        this.execution.cancelledIndex = this.policyIndex;
                        if (((Timeout)this.policy).canInterrupt()) {
                            AbstractExecution abstractExecution = this.execution;
                            synchronized (abstractExecution) {
                                if (this.execution.canInterrupt) {
                                    this.execution.record((ExecutionResult)result.get(), true);
                                    this.execution.interrupted = true;
                                    executionThread.interrupt();
                                }
                            }
                        }
                    }
                    return null;
                }, ((Timeout)this.policy).getTimeout().toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (Throwable t2) {
                return this.postExecute(ExecutionResult.failure(t2));
            }
            if (result.compareAndSet(null, supplier.get())) {
                timeoutFuture.cancel(false);
            }
            return this.postExecute((ExecutionResult)result.get());
        };
    }

    @Override
    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, FailsafeFuture<R> future) {
        return () -> {
            AtomicReference executionResult = new AtomicReference();
            CompletableFuture promise = new CompletableFuture();
            AtomicReference timeoutFuture = new AtomicReference();
            if (!this.execution.isAsyncExecution()) {
                FailsafeFuture failsafeFuture = future;
                synchronized (failsafeFuture) {
                    if (!future.isDone()) {
                        try {
                            timeoutFuture.set(Scheduler.DEFAULT.schedule(() -> {
                                ExecutionResult cancelResult = ExecutionResult.failure(new TimeoutExceededException((Timeout)this.policy));
                                if (executionResult.compareAndSet(null, cancelResult)) {
                                    boolean canInterrupt = ((Timeout)this.policy).canInterrupt();
                                    if (canInterrupt) {
                                        this.execution.record((ExecutionResult)executionResult.get(), true);
                                    }
                                    this.execution.cancelledIndex = this.policyIndex;
                                    future.cancelDependencies(canInterrupt, cancelResult);
                                }
                                return null;
                            }, ((Timeout)this.policy).getTimeout().toNanos(), TimeUnit.NANOSECONDS));
                            future.injectTimeout((Future)timeoutFuture.get());
                        }
                        catch (Throwable t2) {
                            promise.completeExceptionally(t2);
                            return promise;
                        }
                    }
                }
            }
            ((CompletableFuture)supplier.get()).whenComplete((result, error) -> {
                if (executionResult.compareAndSet(null, result)) {
                    if (error != null) {
                        promise.completeExceptionally((Throwable)error);
                        return;
                    }
                    Future maybeFuture = (Future)timeoutFuture.get();
                    if (maybeFuture != null) {
                        maybeFuture.cancel(false);
                    }
                } else {
                    try {
                        result = (ExecutionResult)executionResult.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.postExecuteAsync((ExecutionResult)result, scheduler, future);
                promise.complete(result);
            });
            return promise;
        };
    }
}

