/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.spi.mapper;

import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.com.jayway.jsonpath.Configuration;
import wiremock.com.jayway.jsonpath.TypeRef;
import wiremock.com.jayway.jsonpath.spi.mapper.MappingException;
import wiremock.com.jayway.jsonpath.spi.mapper.MappingProvider;

public class JacksonMappingProvider
implements MappingProvider {
    private final ObjectMapper objectMapper;

    public JacksonMappingProvider() {
        this(new ObjectMapper());
    }

    public JacksonMappingProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T map(Object source2, Class<T> targetType, Configuration configuration) {
        if (source2 == null) {
            return null;
        }
        try {
            return this.objectMapper.convertValue(source2, targetType);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }

    @Override
    public <T> T map(Object source2, TypeRef<T> targetType, Configuration configuration) {
        if (source2 == null) {
            return null;
        }
        JavaType type = this.objectMapper.getTypeFactory().constructType(targetType.getType());
        try {
            return this.objectMapper.convertValue(source2, type);
        }
        catch (Exception e) {
            throw new MappingException(e);
        }
    }
}

