/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;
import wiremock.net.javacrumbs.jsonunit.core.internal.GenericNodeBuilder;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.net.javacrumbs.jsonunit.core.internal.NodeFactory;
import wiremock.net.javacrumbs.jsonunit.core.internal.Utils;

abstract class AbstractNodeFactory
implements NodeFactory {
    AbstractNodeFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node convertToNode(Object source2, String label, boolean lenient) {
        if (source2 == null) {
            return this.nullNode();
        }
        if (source2 instanceof Node) {
            return (Node)source2;
        }
        if (source2 instanceof String && ((String)source2).trim().length() > 0) {
            return this.readValue((String)source2, label, lenient);
        }
        if (source2 instanceof Reader) {
            try {
                Node node = this.readValue((Reader)source2, label, lenient);
                return node;
            }
            finally {
                Utils.closeQuietly((Reader)source2);
            }
        }
        return this.convertValue(source2);
    }

    @Override
    public Node valueToNode(Object source2) {
        if (source2 == null) {
            return this.nullNode();
        }
        return this.convertValue(source2);
    }

    final Node convertValue(Object source2) {
        if (source2 instanceof BigDecimal) {
            return new GenericNodeBuilder.NumberNode((Number)source2);
        }
        return this.doConvertValue(source2);
    }

    @NotNull
    protected IllegalArgumentException newParseException(String label, Reader value, Exception e) {
        if (value instanceof Utils.JsonStringReader) {
            return new IllegalArgumentException("Can not parse " + label + " value: '" + ((Utils.JsonStringReader)value).getString() + "'", e);
        }
        return new IllegalArgumentException("Can not parse " + label + " value.", e);
    }

    protected abstract Node doConvertValue(Object var1);

    protected abstract Node readValue(Reader var1, String var2, boolean var3);

    Node readValue(String source2, String label, boolean lenient) {
        return this.readValue(Utils.toReader(source2), label, lenient);
    }

    protected abstract Node nullNode();
}

