/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import wiremock.org.custommonkey.xmlunit.DoctypeSupport;

public class DoctypeReader
extends Reader {
    private final BufferedReader originalReader;
    private final StringBuilder sourceBuilder = new StringBuilder(1024);
    private final DoctypeSupport support;

    public DoctypeReader(Reader originalSource, String doctypeName, String systemID) {
        this.originalReader = originalSource instanceof BufferedReader ? (BufferedReader)originalSource : new BufferedReader(originalSource);
        this.support = new DoctypeSupport(doctypeName, systemID, new DoctypeSupport.Readable(){

            @Override
            public int read() throws IOException {
                return DoctypeReader.this.originalReader.read();
            }
        }, true, null);
    }

    protected String getContent() throws IOException {
        return this.getContent(this.originalReader).toString();
    }

    private StringBuilder getContent(BufferedReader originalSource) throws IOException {
        if (this.sourceBuilder.length() == 0) {
            String source2;
            String newline = System.getProperty("line.separator");
            boolean atFirstLine = true;
            while ((source2 = originalSource.readLine()) != null) {
                if (atFirstLine) {
                    atFirstLine = false;
                } else {
                    this.sourceBuilder.append(newline);
                }
                this.sourceBuilder.append(source2);
            }
            originalSource.close();
        }
        return this.sourceBuilder;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int currentlyRead;
        int startPos = off;
        while (off - startPos < len && (currentlyRead = this.read()) != -1) {
            cbuf[off++] = (char)currentlyRead;
        }
        return off == startPos && len != 0 ? -1 : off - startPos;
    }

    @Override
    public int read() throws IOException {
        return this.support.read();
    }

    @Override
    public void close() throws IOException {
        this.originalReader.close();
    }
}

