/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.auth;

import com.auth0.utils.Asserts;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class LogoutUrlBuilder {
    private final HttpUrl.Builder builder;
    private final Map<String, String> parameters;

    static LogoutUrlBuilder newInstance(HttpUrl baseUrl, String clientId, String returnToUrl, boolean setClientId) {
        return new LogoutUrlBuilder(baseUrl, setClientId ? clientId : null, returnToUrl);
    }

    private LogoutUrlBuilder(HttpUrl url, String clientId, String returnToUrl) {
        Asserts.assertNotNull(url, "base url");
        Asserts.assertNotNull(returnToUrl, "return to url");
        this.parameters = new HashMap<String, String>();
        this.builder = url.newBuilder().addPathSegment("v2").addPathSegment("logout").addEncodedQueryParameter("returnTo", returnToUrl);
        if (clientId != null) {
            this.builder.addQueryParameter("client_id", clientId);
        }
    }

    public LogoutUrlBuilder useFederated(boolean federated) {
        if (federated) {
            this.parameters.put("federated", "");
        } else {
            this.parameters.remove("federated");
        }
        return this;
    }

    public String build() {
        for (Map.Entry<String, String> p : this.parameters.entrySet()) {
            this.builder.addQueryParameter(p.getKey(), p.getValue());
        }
        return this.builder.build().toString();
    }
}

