/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.RequestBuilder;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import java.util.function.Consumer;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

abstract class BaseManagementEntity {
    protected final Auth0HttpClient client;
    protected final HttpUrl baseUrl;
    protected final TokenProvider tokenProvider;

    BaseManagementEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.tokenProvider = tokenProvider;
    }

    protected Request<Void> voidRequest(HttpMethod method, Consumer<RequestBuilder<Void>> customizer) {
        return this.customizeRequest(new RequestBuilder<Void>(this.client, this.tokenProvider, method, this.baseUrl, new TypeReference<Void>(){}), customizer);
    }

    protected <T> Request<T> request(HttpMethod method, TypeReference<T> target, Consumer<RequestBuilder<T>> customizer) {
        return this.customizeRequest(new RequestBuilder<T>(this.client, this.tokenProvider, method, this.baseUrl, target), customizer);
    }

    private <T> Request<T> customizeRequest(RequestBuilder<T> builder, Consumer<RequestBuilder<T>> customizer) {
        customizer.accept(builder);
        return builder.build();
    }
}

