/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.emailtemplates.EmailTemplate;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class EmailTemplatesEntity
extends BaseManagementEntity {
    public static final String TEMPLATE_VERIFY_EMAIL = "verify_email";
    public static final String TEMPLATE_RESET_EMAIL = "reset_email";
    public static final String TEMPLATE_WELCOME_EMAIL = "welcome_email";
    public static final String TEMPLATE_BLOCKED_ACCOUNT = "blocked_account";
    public static final String TEMPLATE_STOLEN_CREDENTIALS = "stolen_credentials";
    public static final String TEMPLATE_ENROLLMENT_EMAIL = "enrollment_email";
    public static final String TEMPLATE_CHANGE_PASSWORD = "change_password";
    public static final String TEMPLATE_PASSWORD_RESET = "password_reset";
    public static final String TEMPLATE_MFA_OOB_CODE = "mfa_oob_code";

    EmailTemplatesEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<EmailTemplate> get(String templateName) {
        Asserts.assertNotNull(templateName, "template name");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/email-templates").addPathSegment(templateName);
        String url = builder.build().toString();
        return new BaseRequest<EmailTemplate>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<EmailTemplate>(){});
    }

    public Request<EmailTemplate> create(EmailTemplate template) {
        Asserts.assertNotNull(template, "template");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/email-templates").build().toString();
        BaseRequest<EmailTemplate> request = new BaseRequest<EmailTemplate>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<EmailTemplate>(){});
        request.setBody(template);
        return request;
    }

    public Request<EmailTemplate> update(String templateName, EmailTemplate template) {
        Asserts.assertNotNull(templateName, "template name");
        Asserts.assertNotNull(template, "template");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/email-templates").addPathSegment(templateName).build().toString();
        BaseRequest<EmailTemplate> request = new BaseRequest<EmailTemplate>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<EmailTemplate>(){});
        request.setBody(template);
        return request;
    }
}

