/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.GrantsFilter;
import com.auth0.json.mgmt.grants.GrantsPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class GrantsEntity
extends BaseManagementEntity {
    GrantsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<GrantsPage> list(String userId, GrantsFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/grants").addQueryParameter("user_id", userId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<GrantsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<GrantsPage>(){});
    }

    public Request<Void> delete(String grantId) {
        Asserts.assertNotNull(grantId, "grant id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/grants").addPathSegment(grantId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<Void> deleteAll(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/grants").addQueryParameter("user_id", userId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }
}

