/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.UsersExportFilter;
import com.auth0.client.mgmt.filter.UsersImportOptions;
import com.auth0.json.mgmt.jobs.Job;
import com.auth0.json.mgmt.jobs.JobErrorDetails;
import com.auth0.json.mgmt.tickets.EmailVerificationIdentity;
import com.auth0.net.BaseRequest;
import com.auth0.net.MultipartRequest;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.Auth0HttpResponse;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class JobsEntity
extends BaseManagementEntity {
    JobsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<Job> get(String jobId) {
        Asserts.assertNotNull(jobId, "job id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs").addPathSegment(jobId).build().toString();
        return new BaseRequest<Job>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Job>(){});
    }

    public Request<List<JobErrorDetails>> getErrorDetails(String jobId) {
        Asserts.assertNotNull(jobId, "job id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs").addPathSegment(jobId).addPathSegment("errors").build().toString();
        TypeReference<List<JobErrorDetails>> jobErrorDetailsListType = new TypeReference<List<JobErrorDetails>>(){};
        return new BaseRequest<List<JobErrorDetails>>(this.client, this.tokenProvider, url, HttpMethod.GET, (TypeReference)jobErrorDetailsListType){

            @Override
            protected List<JobErrorDetails> readResponseBody(Auth0HttpResponse response) throws IOException {
                if (response.getBody() == null || response.getBody().length() == 0) {
                    return Collections.emptyList();
                }
                return (List)super.readResponseBody(response);
            }
        };
    }

    public Request<Job> sendVerificationEmail(String userId, String clientId) {
        return this.sendVerificationEmail(userId, clientId, null);
    }

    public Request<Job> sendVerificationEmail(String userId, String clientId, EmailVerificationIdentity emailVerificationIdentity) {
        return this.sendVerificationEmail(userId, clientId, emailVerificationIdentity, null);
    }

    public Request<Job> sendVerificationEmail(String userId, String clientId, EmailVerificationIdentity emailVerificationIdentity, String orgId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs/verification-email").build().toString();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("user_id", userId);
        if (clientId != null && !clientId.isEmpty()) {
            requestBody.put("client_id", clientId);
        }
        if (orgId != null && !orgId.isEmpty()) {
            requestBody.put("organization_id", orgId);
        }
        if (emailVerificationIdentity != null) {
            Asserts.assertNotNull(emailVerificationIdentity.getProvider(), "identity provider");
            Asserts.assertNotNull(emailVerificationIdentity.getUserId(), "identity user id");
            requestBody.put("identity", emailVerificationIdentity);
        }
        BaseRequest<Job> request = new BaseRequest<Job>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Job>(){});
        request.setBody(requestBody);
        return request;
    }

    @Deprecated
    public Request<Job> exportUsers(String connectionId, UsersExportFilter filter) {
        Asserts.assertNotNull(connectionId, "connection id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs/users-exports").build().toString();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("connection_id", connectionId);
        if (filter != null) {
            requestBody.putAll(filter.getAsMap());
        }
        BaseRequest<Job> request = new BaseRequest<Job>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Job>(){});
        request.setBody(requestBody);
        return request;
    }

    public Request<Job> exportUsers(UsersExportFilter filter) {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs/users-exports").build().toString();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        if (filter != null) {
            requestBody.putAll(filter.getAsMap());
        }
        BaseRequest<Job> request = new BaseRequest<Job>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Job>(){});
        request.setBody(requestBody);
        return request;
    }

    public Request<Job> importUsers(String connectionId, File users, UsersImportOptions options) {
        Asserts.assertNotNull(connectionId, "connection id");
        Asserts.assertNotNull(users, "users file");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/jobs/users-imports").build().toString();
        MultipartRequest<Job> request = new MultipartRequest<Job>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Job>(){});
        if (options != null) {
            for (Map.Entry<String, Object> e : options.getAsMap().entrySet()) {
                request.addPart(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        request.addPart("connection_id", connectionId);
        request.addPart("users", users, "text/json");
        return request;
    }
}

