/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.keys.Key;
import com.auth0.net.BaseRequest;
import com.auth0.net.EmptyBodyRequest;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.List;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class KeysEntity
extends BaseManagementEntity {
    KeysEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<List<Key>> list() {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/keys/signing");
        String url = builder.build().toString();
        return new BaseRequest<List<Key>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<Key>>(){});
    }

    public Request<Key> get(String kid) {
        Asserts.assertNotNull(kid, "kid");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/keys/signing").addPathSegment(kid);
        String url = builder.build().toString();
        return new BaseRequest<Key>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Key>(){});
    }

    public Request<Key> rotate() {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/keys/signing/rotate").build().toString();
        return new EmptyBodyRequest<Key>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Key>(){});
    }

    public Request<Key> revoke(String kid) {
        Asserts.assertNotNull(kid, "kid");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/keys/signing/").addPathSegment(kid).addPathSegment("revoke").build().toString();
        return new EmptyBodyRequest<Key>(this.client, this.tokenProvider, url, HttpMethod.PUT, new TypeReference<Key>(){});
    }
}

