/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.LogEventFilter;
import com.auth0.json.mgmt.logevents.LogEvent;
import com.auth0.json.mgmt.logevents.LogEventsPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class LogEventsEntity
extends BaseManagementEntity {
    LogEventsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<LogEventsPage> list(LogEventFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/logs");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                if ("q".equals(e.getKey())) {
                    builder.addEncodedQueryParameter(e.getKey(), String.valueOf(e.getValue()));
                    continue;
                }
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<LogEventsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<LogEventsPage>(){});
    }

    public Request<LogEvent> get(String logEventId) {
        Asserts.assertNotNull(logEventId, "log event id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/logs").addPathSegment(logEventId).build().toString();
        return new BaseRequest<LogEvent>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<LogEvent>(){});
    }
}

