/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.logstreams.LogStream;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.List;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class LogStreamsEntity
extends BaseManagementEntity {
    private static final String LOG_STREAMS_PATH = "api/v2/log-streams";

    LogStreamsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<List<LogStream>> list() {
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).build().toString();
        return new BaseRequest<List<LogStream>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<LogStream>>(){});
    }

    public Request<LogStream> get(String logStreamId) {
        Asserts.assertNotNull(logStreamId, "log stream id");
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).addPathSegment(logStreamId).build().toString();
        return new BaseRequest<LogStream>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<LogStream>(){});
    }

    public Request<LogStream> create(LogStream logStream) {
        Asserts.assertNotNull(logStream, "log stream");
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).build().toString();
        BaseRequest<LogStream> request = new BaseRequest<LogStream>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<LogStream>(){});
        request.setBody(logStream);
        return request;
    }

    public Request<LogStream> update(String logStreamId, LogStream logStream) {
        Asserts.assertNotNull(logStreamId, "log stream id");
        Asserts.assertNotNull(logStream, "log stream");
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).addPathSegment(logStreamId).build().toString();
        BaseRequest<LogStream> request = new BaseRequest<LogStream>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<LogStream>(){});
        request.setBody(logStream);
        return request;
    }

    public Request<Void> delete(String logStreamId) {
        Asserts.assertNotNull(logStreamId, "log stream id");
        String url = this.baseUrl.newBuilder().addPathSegments(LOG_STREAMS_PATH).addPathSegment(logStreamId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }
}

