/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.TokenProvider;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.Nullable;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

class RequestBuilder<T> {
    private final Auth0HttpClient client;
    private final TokenProvider tokenProvider;
    private final HttpMethod method;
    private final HttpUrl.Builder url;
    private final TypeReference<T> target;
    @Nullable
    private Object body = null;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public RequestBuilder(Auth0HttpClient client, TokenProvider tokenProvider, HttpMethod method, HttpUrl baseUrl, TypeReference<T> target) {
        this.client = client;
        this.tokenProvider = tokenProvider;
        this.method = method;
        this.url = baseUrl.newBuilder();
        this.target = target;
    }

    public RequestBuilder<T> withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public RequestBuilder<T> withParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public RequestBuilder<T> withBody(Object body) {
        this.body = body;
        return this;
    }

    public RequestBuilder<T> withPathSegments(String path) {
        this.url.addPathSegments(path);
        return this;
    }

    public Request<T> build() {
        String url = this.url.build().toString();
        BaseRequest request = "java.lang.Void".equals(this.target.getType().getTypeName()) ? new VoidRequest(this.client, this.tokenProvider, url, this.method) : new BaseRequest<T>(this.client, this.tokenProvider, url, this.method, this.target);
        if (this.body != null) {
            request.setBody(this.body);
        }
        this.headers.forEach(request::addHeader);
        this.parameters.forEach(request::addParameter);
        return request;
    }
}

