/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.ResourceServersFilter;
import com.auth0.json.mgmt.resourceserver.ResourceServer;
import com.auth0.json.mgmt.resourceserver.ResourceServersPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class ResourceServerEntity
extends BaseManagementEntity {
    ResourceServerEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<ResourceServersPage> list(ResourceServersFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<ResourceServersPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<ResourceServersPage>(){});
    }

    public Request<ResourceServer> get(String resourceServerIdOrIdentifier) {
        Asserts.assertNotNull(resourceServerIdOrIdentifier, "Resource server ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers").addPathSegment(resourceServerIdOrIdentifier);
        String url = builder.build().toString();
        return new BaseRequest<ResourceServer>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<ResourceServer>(){});
    }

    public Request<ResourceServer> create(ResourceServer resourceServer) {
        Asserts.assertNotNull(resourceServer, "Resource server");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers");
        String url = builder.build().toString();
        BaseRequest<ResourceServer> request = new BaseRequest<ResourceServer>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<ResourceServer>(){});
        request.setBody(resourceServer);
        return request;
    }

    public Request<Void> delete(String resourceServerId) {
        Asserts.assertNotNull(resourceServerId, "Resource server ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers").addPathSegment(resourceServerId);
        String url = builder.build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<ResourceServer> update(String resourceServerId, ResourceServer resourceServer) {
        Asserts.assertNotNull(resourceServerId, "resourceServerId");
        Asserts.assertNotNull(resourceServer, "resourceServer");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/resource-servers").addPathSegment(resourceServerId);
        String url = builder.build().toString();
        BaseRequest<ResourceServer> request = new BaseRequest<ResourceServer>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<ResourceServer>(){});
        request.setBody(resourceServer);
        return request;
    }
}

