/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.client.mgmt.filter.RolesFilter;
import com.auth0.json.mgmt.permissions.Permission;
import com.auth0.json.mgmt.permissions.PermissionsPage;
import com.auth0.json.mgmt.roles.Role;
import com.auth0.json.mgmt.roles.RolesPage;
import com.auth0.json.mgmt.users.UsersPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class RolesEntity
extends BaseManagementEntity {
    RolesEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<RolesPage> list(RolesFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<RolesPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<RolesPage>(){});
    }

    public Request<Role> get(String roleId) {
        Asserts.assertNotNull(roleId, "role id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId);
        String url = builder.build().toString();
        return new BaseRequest<Role>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Role>(){});
    }

    public Request<Role> create(Role role) {
        Asserts.assertNotNull(role, "role");
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").build().toString();
        BaseRequest<Role> request = new BaseRequest<Role>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<Role>(){});
        request.setBody(role);
        return request;
    }

    public Request<Void> delete(String roleId) {
        Asserts.assertNotNull(roleId, "role id");
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<Role> update(String roleId, Role role) {
        Asserts.assertNotNull(roleId, "role id");
        Asserts.assertNotNull(role, "role");
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).build().toString();
        BaseRequest<Role> request = new BaseRequest<Role>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<Role>(){});
        request.setBody(role);
        return request;
    }

    public Request<UsersPage> listUsers(String roleId, PageFilter filter) {
        Asserts.assertNotNull(roleId, "role id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("users");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<UsersPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<UsersPage>(){});
    }

    public Request<Void> assignUsers(String roleId, List<String> userIds) {
        Asserts.assertNotNull(roleId, "role id");
        Asserts.assertNotEmpty(userIds, "user ids");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("users", userIds);
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("users").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.POST);
        request.setBody(body);
        return request;
    }

    public Request<PermissionsPage> listPermissions(String roleId, PageFilter filter) {
        Asserts.assertNotNull(roleId, "role id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("permissions");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<PermissionsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<PermissionsPage>(){});
    }

    public Request<Void> removePermissions(String roleId, List<Permission> permissions) {
        Asserts.assertNotNull(roleId, "role id");
        Asserts.assertNotEmpty(permissions, "permissions");
        HashMap<String, List<Permission>> body = new HashMap<String, List<Permission>>();
        body.put("permissions", permissions);
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("permissions").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
        request.setBody(body);
        return request;
    }

    public Request<Void> addPermissions(String roleId, List<Permission> permissions) {
        Asserts.assertNotNull(roleId, "role id");
        Asserts.assertNotEmpty(permissions, "permissions");
        HashMap<String, List<Permission>> body = new HashMap<String, List<Permission>>();
        body.put("permissions", permissions);
        String url = this.baseUrl.newBuilder().addEncodedPathSegments("api/v2/roles").addEncodedPathSegments(roleId).addEncodedPathSegments("permissions").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.POST);
        request.setBody(body);
        return request;
    }
}

