/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.json.mgmt.stats.DailyStats;
import com.auth0.net.BaseRequest;
import com.auth0.net.Request;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class StatsEntity
extends BaseManagementEntity {
    StatsEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<Integer> getActiveUsersCount() {
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/stats/active-users").build().toString();
        return new BaseRequest<Integer>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<Integer>(){});
    }

    public Request<List<DailyStats>> getDailyStats(Date from, Date to) {
        Asserts.assertNotNull(from, "date from");
        Asserts.assertNotNull(to, "date to");
        String dateFrom = this.formatDate(from);
        String dateTo = this.formatDate(to);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/stats/daily").addQueryParameter("from", dateFrom).addQueryParameter("to", dateTo).build().toString();
        return new BaseRequest<List<DailyStats>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<DailyStats>>(){});
    }

    protected String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(date);
    }
}

