/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.client.mgmt;

import com.auth0.client.mgmt.BaseManagementEntity;
import com.auth0.client.mgmt.TokenProvider;
import com.auth0.client.mgmt.filter.BaseFilter;
import com.auth0.client.mgmt.filter.FieldsFilter;
import com.auth0.client.mgmt.filter.LogEventFilter;
import com.auth0.client.mgmt.filter.PageFilter;
import com.auth0.client.mgmt.filter.UserFilter;
import com.auth0.json.mgmt.guardian.Enrollment;
import com.auth0.json.mgmt.logevents.LogEventsPage;
import com.auth0.json.mgmt.organizations.OrganizationsPage;
import com.auth0.json.mgmt.permissions.Permission;
import com.auth0.json.mgmt.permissions.PermissionsPage;
import com.auth0.json.mgmt.roles.RolesPage;
import com.auth0.json.mgmt.users.Identity;
import com.auth0.json.mgmt.users.RecoveryCode;
import com.auth0.json.mgmt.users.User;
import com.auth0.json.mgmt.users.UsersPage;
import com.auth0.json.mgmt.users.authenticationmethods.AuthenticationMethod;
import com.auth0.json.mgmt.users.authenticationmethods.AuthenticationMethodsPage;
import com.auth0.net.BaseRequest;
import com.auth0.net.EmptyBodyRequest;
import com.auth0.net.Request;
import com.auth0.net.VoidRequest;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.HttpMethod;
import com.auth0.utils.Asserts;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;

public class UsersEntity
extends BaseManagementEntity {
    UsersEntity(Auth0HttpClient client, HttpUrl baseUrl, TokenProvider tokenProvider) {
        super(client, baseUrl, tokenProvider);
    }

    public Request<List<User>> listByEmail(String email, FieldsFilter filter) {
        Asserts.assertNotNull(email, "email");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users-by-email");
        builder.addQueryParameter("email", email);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<List<User>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<User>>(){});
    }

    public Request<UsersPage> list(UserFilter filter) {
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users");
        UsersEntity.encodeAndAddQueryParam(builder, filter);
        String url = builder.build().toString();
        return new BaseRequest<UsersPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<UsersPage>(){});
    }

    public Request<User> get(String userId, UserFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId);
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<User>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<User>(){});
    }

    public Request<User> create(User user) {
        Asserts.assertNotNull(user, "user");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").build().toString();
        BaseRequest<User> request = new BaseRequest<User>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<User>(){});
        request.setBody(user);
        return request;
    }

    public Request<Void> delete(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<User> update(String userId, User user) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotNull(user, "user");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).build().toString();
        BaseRequest<User> request = new BaseRequest<User>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<User>(){});
        request.setBody(user);
        return request;
    }

    public Request<List<Enrollment>> getEnrollments(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("enrollments").build().toString();
        return new BaseRequest<List<Enrollment>>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<List<Enrollment>>(){});
    }

    public Request<LogEventsPage> getLogEvents(String userId, LogEventFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("logs");
        UsersEntity.encodeAndAddQueryParam(builder, filter);
        String url = builder.build().toString();
        return new BaseRequest<LogEventsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<LogEventsPage>(){});
    }

    public Request<Void> deleteAllAuthenticators(String userId) {
        Asserts.assertNotNull(userId, "user id");
        return this.voidRequest(HttpMethod.DELETE, builder -> builder.withPathSegments(String.format("api/v2/users/%s/authenticators", userId)));
    }

    public Request<Void> deleteMultifactorProvider(String userId, String provider) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotNull(provider, "provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("multifactor").addPathSegment(provider).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<RecoveryCode> rotateRecoveryCode(String userId) {
        Asserts.assertNotNull(userId, "user id");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("recovery-code-regeneration").build().toString();
        return new EmptyBodyRequest<RecoveryCode>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<RecoveryCode>(){});
    }

    public Request<List<Identity>> linkIdentity(String primaryUserId, String secondaryUserId, String provider, String connectionId) {
        Asserts.assertNotNull(primaryUserId, "primary user id");
        Asserts.assertNotNull(secondaryUserId, "secondary user id");
        Asserts.assertNotNull(provider, "provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(primaryUserId).addPathSegment("identities").build().toString();
        BaseRequest<List<Identity>> request = new BaseRequest<List<Identity>>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<List<Identity>>(){});
        request.addParameter("provider", provider);
        request.addParameter("user_id", secondaryUserId);
        if (connectionId != null) {
            request.addParameter("connection_id", connectionId);
        }
        return request;
    }

    public Request<List<Identity>> linkIdentity(String primaryUserId, String secondaryIdToken) {
        Asserts.assertNotNull(primaryUserId, "primary user id");
        Asserts.assertNotNull(secondaryIdToken, "secondary id token");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(primaryUserId).addPathSegment("identities").build().toString();
        BaseRequest<List<Identity>> request = new BaseRequest<List<Identity>>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<List<Identity>>(){});
        request.addParameter("link_with", secondaryIdToken);
        return request;
    }

    public Request<List<Identity>> unlinkIdentity(String primaryUserId, String secondaryUserId, String provider) {
        Asserts.assertNotNull(primaryUserId, "primary user id");
        Asserts.assertNotNull(secondaryUserId, "secondary user id");
        Asserts.assertNotNull(provider, "provider");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(primaryUserId).addPathSegment("identities").addPathSegment(provider).addPathSegment(secondaryUserId).build().toString();
        return new BaseRequest<List<Identity>>(this.client, this.tokenProvider, url, HttpMethod.DELETE, new TypeReference<List<Identity>>(){});
    }

    public Request<Void> invalidateRememberedBrowsers(String userId) {
        Asserts.assertNotNull(userId, "user ID");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegments("multifactor/actions/invalidate-remember-browser").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.POST);
        request.setBody("");
        return request;
    }

    public Request<PermissionsPage> listPermissions(String userId, PageFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("permissions");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<PermissionsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<PermissionsPage>(){});
    }

    public Request<Void> removePermissions(String userId, List<Permission> permissions) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotEmpty(permissions, "permissions");
        HashMap<String, List<Permission>> body = new HashMap<String, List<Permission>>();
        body.put("permissions", permissions);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("permissions").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
        request.setBody(body);
        return request;
    }

    public Request<Void> addPermissions(String userId, List<Permission> permissions) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotEmpty(permissions, "permissions");
        HashMap<String, List<Permission>> body = new HashMap<String, List<Permission>>();
        body.put("permissions", permissions);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("permissions").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.POST);
        request.setBody(body);
        return request;
    }

    public Request<RolesPage> listRoles(String userId, PageFilter filter) {
        Asserts.assertNotNull(userId, "user id");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("roles");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<RolesPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<RolesPage>(){});
    }

    public Request<Void> removeRoles(String userId, List<String> roleIds) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotEmpty(roleIds, "role ids");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("roles", roleIds);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("roles").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
        request.setBody(body);
        return request;
    }

    public Request<Void> addRoles(String userId, List<String> roleIds) {
        Asserts.assertNotNull(userId, "user id");
        Asserts.assertNotEmpty(roleIds, "role ids");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        body.put("roles", roleIds);
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegments(userId).addPathSegments("roles").build().toString();
        VoidRequest request = new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.POST);
        request.setBody(body);
        return request;
    }

    public Request<OrganizationsPage> getOrganizations(String userId, PageFilter filter) {
        Asserts.assertNotNull(userId, "user ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("organizations");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<OrganizationsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<OrganizationsPage>(){});
    }

    public Request<AuthenticationMethodsPage> getAuthenticationMethods(String userId, PageFilter filter) {
        Asserts.assertNotNull(userId, "user ID");
        HttpUrl.Builder builder = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("authentication-methods");
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        String url = builder.build().toString();
        return new BaseRequest<AuthenticationMethodsPage>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<AuthenticationMethodsPage>(){});
    }

    public Request<AuthenticationMethod> createAuthenticationMethods(String userId, AuthenticationMethod authenticationMethod) {
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(authenticationMethod, "authentication methods");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("authentication-methods").build().toString();
        BaseRequest<AuthenticationMethod> request = new BaseRequest<AuthenticationMethod>(this.client, this.tokenProvider, url, HttpMethod.POST, new TypeReference<AuthenticationMethod>(){});
        request.setBody(authenticationMethod);
        return request;
    }

    public Request<List<AuthenticationMethod>> updateAuthenticationMethods(String userId, List<AuthenticationMethod> authenticationMethods) {
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(authenticationMethods, "authentication methods");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("authentication-methods").build().toString();
        BaseRequest<List<AuthenticationMethod>> request = new BaseRequest<List<AuthenticationMethod>>(this.client, this.tokenProvider, url, HttpMethod.PUT, new TypeReference<List<AuthenticationMethod>>(){});
        request.setBody(authenticationMethods);
        return request;
    }

    public Request<AuthenticationMethod> getAuthenticationMethodById(String userId, String authenticationMethodId) {
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(authenticationMethodId, "authentication method ID");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("authentication-methods").addPathSegment(authenticationMethodId).build().toString();
        return new BaseRequest<AuthenticationMethod>(this.client, this.tokenProvider, url, HttpMethod.GET, new TypeReference<AuthenticationMethod>(){});
    }

    public Request<Void> deleteAuthenticationMethodById(String userId, String authenticationMethodId) {
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(authenticationMethodId, "authentication method ID");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("authentication-methods").addPathSegment(authenticationMethodId).build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<Void> deleteAllAuthenticationMethods(String userId) {
        Asserts.assertNotNull(userId, "user ID");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("authentication-methods").build().toString();
        return new VoidRequest(this.client, this.tokenProvider, url, HttpMethod.DELETE);
    }

    public Request<AuthenticationMethod> updateAuthenticationMethodById(String userId, String authenticationMethodId, AuthenticationMethod authenticationMethod) {
        Asserts.assertNotNull(userId, "user ID");
        Asserts.assertNotNull(authenticationMethodId, "authentication method ID");
        Asserts.assertNotNull(authenticationMethod, "authentication method");
        String url = this.baseUrl.newBuilder().addPathSegments("api/v2/users").addPathSegment(userId).addPathSegment("authentication-methods").addPathSegment(authenticationMethodId).build().toString();
        BaseRequest<AuthenticationMethod> request = new BaseRequest<AuthenticationMethod>(this.client, this.tokenProvider, url, HttpMethod.PATCH, new TypeReference<AuthenticationMethod>(){});
        request.setBody(authenticationMethod);
        return request;
    }

    private static void encodeAndAddQueryParam(HttpUrl.Builder builder, BaseFilter filter) {
        if (filter != null) {
            for (Map.Entry<String, Object> e : filter.getAsMap().entrySet()) {
                if ("q".equals(e.getKey())) {
                    builder.addEncodedQueryParameter(e.getKey(), String.valueOf(e.getValue()));
                    continue;
                }
                builder.addQueryParameter(e.getKey(), String.valueOf(e.getValue()));
            }
        }
    }
}

