/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import java.io.IOException;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.core.ObjectCodec;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;
import wiremock.com.fasterxml.jackson.databind.JsonNode;

class JsonNodeClaim
implements Claim {
    private final ObjectCodec codec;
    private final JsonNode data;

    private JsonNodeClaim(JsonNode node, ObjectCodec codec) {
        this.data = node;
        this.codec = codec;
    }

    @Override
    public Boolean asBoolean() {
        return this.isMissing() || this.isNull() || !this.data.isBoolean() ? null : Boolean.valueOf(this.data.asBoolean());
    }

    @Override
    public Integer asInt() {
        return this.isMissing() || this.isNull() || !this.data.isNumber() ? null : Integer.valueOf(this.data.asInt());
    }

    @Override
    public Long asLong() {
        return this.isMissing() || this.isNull() || !this.data.isNumber() ? null : Long.valueOf(this.data.asLong());
    }

    @Override
    public Double asDouble() {
        return this.isMissing() || this.isNull() || !this.data.isNumber() ? null : Double.valueOf(this.data.asDouble());
    }

    @Override
    public String asString() {
        return this.isMissing() || this.isNull() || !this.data.isTextual() ? null : this.data.asText();
    }

    @Override
    public Date asDate() {
        if (this.isMissing() || this.isNull() || !this.data.canConvertToLong()) {
            return null;
        }
        long seconds = this.data.asLong();
        return new Date(seconds * 1000L);
    }

    @Override
    public Instant asInstant() {
        if (this.isMissing() || this.isNull() || !this.data.canConvertToLong()) {
            return null;
        }
        long seconds = this.data.asLong();
        return Instant.ofEpochSecond(seconds);
    }

    @Override
    public <T> T[] asArray(Class<T> clazz) throws JWTDecodeException {
        if (this.isMissing() || this.isNull() || !this.data.isArray()) {
            return null;
        }
        Object[] arr = (Object[])Array.newInstance(clazz, this.data.size());
        for (int i = 0; i < this.data.size(); ++i) {
            try {
                arr[i] = this.codec.treeToValue(this.data.get(i), clazz);
                continue;
            }
            catch (JsonProcessingException e) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + clazz.getSimpleName(), e);
            }
        }
        return arr;
    }

    @Override
    public <T> List<T> asList(Class<T> clazz) throws JWTDecodeException {
        if (this.isMissing() || this.isNull() || !this.data.isArray()) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.data.size(); ++i) {
            try {
                list.add(this.codec.treeToValue(this.data.get(i), clazz));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + clazz.getSimpleName(), e);
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> asMap() throws JWTDecodeException {
        Map map;
        block9: {
            if (this.isMissing() || this.isNull() || !this.data.isObject()) {
                return null;
            }
            TypeReference<Map<String, Object>> mapType = new TypeReference<Map<String, Object>>(){};
            JsonParser parser = this.codec.treeAsTokens(this.data);
            try {
                map = (Map)parser.readValueAs(mapType);
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JWTDecodeException("Couldn't map the Claim value to Map", e);
                }
            }
            parser.close();
        }
        return map;
    }

    @Override
    public <T> T as(Class<T> clazz) throws JWTDecodeException {
        try {
            if (this.isMissing() || this.isNull()) {
                return null;
            }
            return this.codec.treeToValue(this.data, clazz);
        }
        catch (JsonProcessingException e) {
            throw new JWTDecodeException("Couldn't map the Claim value to " + clazz.getSimpleName(), e);
        }
    }

    @Override
    public boolean isNull() {
        return !this.isMissing() && this.data.isNull();
    }

    @Override
    public boolean isMissing() {
        return this.data == null || this.data.isMissingNode();
    }

    public String toString() {
        if (this.isMissing()) {
            return "Missing claim";
        }
        if (this.isNull()) {
            return "Null claim";
        }
        return this.data.toString();
    }

    static Claim extractClaim(String claimName, Map<String, JsonNode> tree, ObjectCodec objectCodec) {
        JsonNode node = tree.get(claimName);
        return JsonNodeClaim.claimFromNode(node, objectCodec);
    }

    static Claim claimFromNode(JsonNode node, ObjectCodec objectCodec) {
        return new JsonNodeClaim(node, objectCodec);
    }
}

