/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.client.mgmt.TokenProvider;
import com.auth0.exception.APIException;
import com.auth0.exception.Auth0Exception;
import com.auth0.exception.RateLimitException;
import com.auth0.json.ObjectMapperProvider;
import com.auth0.net.Request;
import com.auth0.net.Response;
import com.auth0.net.ResponseImpl;
import com.auth0.net.client.Auth0HttpClient;
import com.auth0.net.client.Auth0HttpRequest;
import com.auth0.net.client.Auth0HttpResponse;
import com.auth0.net.client.HttpMethod;
import com.auth0.net.client.HttpRequestBody;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;
import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.com.fasterxml.jackson.databind.type.MapType;

public class BaseRequest<T>
implements Request<T> {
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private final String url;
    private final HttpMethod method;
    private final ObjectMapper mapper;
    private final Map<String, String> headers;
    private final TypeReference<T> tType;
    private final Map<String, Object> parameters;
    private Object body;
    private static final int STATUS_CODE_TOO_MANY_REQUEST = 429;
    private final Auth0HttpClient client;
    private final TokenProvider tokenProvider;

    BaseRequest(Auth0HttpClient client, TokenProvider tokenProvider, String url, HttpMethod method, ObjectMapper mapper, TypeReference<T> tType) {
        this.client = client;
        this.tokenProvider = tokenProvider;
        this.url = url;
        this.method = method;
        this.mapper = mapper;
        this.headers = new HashMap<String, String>();
        this.tType = tType;
        this.parameters = new HashMap<String, Object>();
    }

    public BaseRequest(Auth0HttpClient client, TokenProvider tokenProvider, String url, HttpMethod method, TypeReference<T> tType) {
        this(client, tokenProvider, url, method, ObjectMapperProvider.getMapper(), tType);
    }

    protected Auth0HttpRequest createRequest(String apiToken) throws Auth0Exception {
        HttpRequestBody body;
        try {
            body = this.createRequestBody();
        }
        catch (IOException e) {
            throw new Auth0Exception("Couldn't create the request body.", e);
        }
        this.headers.put("Content-Type", this.getContentType());
        if (Objects.nonNull(apiToken)) {
            this.headers.put("Authorization", "Bearer " + apiToken);
        }
        Auth0HttpRequest request = Auth0HttpRequest.newBuilder(this.url, this.method).withBody(body).withHeaders(this.headers).build();
        return request;
    }

    protected T parseResponseBody(Auth0HttpResponse response) throws Auth0Exception {
        if (!response.isSuccessful()) {
            throw this.createResponseException(response);
        }
        try {
            return this.readResponseBody(response);
        }
        catch (IOException e) {
            throw new APIException("Failed to parse the response body.", response.getCode(), e);
        }
    }

    protected HttpRequestBody createRequestBody() throws IOException {
        if (this.body == null && this.parameters.isEmpty()) {
            return null;
        }
        byte[] jsonBody = this.mapper.writeValueAsBytes(this.body != null ? this.body : this.parameters);
        return HttpRequestBody.create(CONTENT_TYPE_APPLICATION_JSON, jsonBody);
    }

    protected T readResponseBody(Auth0HttpResponse response) throws IOException {
        String payload = response.getBody();
        return this.mapper.readValue(payload, this.tType);
    }

    protected Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public Response<T> execute() throws Auth0Exception {
        String apiToken = null;
        if (Objects.nonNull(this.tokenProvider)) {
            apiToken = this.tokenProvider.getToken();
        }
        Auth0HttpRequest request = this.createRequest(apiToken);
        try {
            Auth0HttpResponse response = this.client.sendRequest(request);
            T body = this.parseResponseBody(response);
            return new ResponseImpl<T>(response.getHeaders(), body, response.getCode());
        }
        catch (Auth0Exception e) {
            throw e;
        }
        catch (IOException ioe) {
            throw new Auth0Exception("Failed to execute the request", ioe);
        }
    }

    @Override
    public CompletableFuture<Response<T>> executeAsync() {
        CompletableFuture<Response<T>> future = new CompletableFuture<Response<T>>();
        if (Objects.nonNull(this.tokenProvider)) {
            return this.tokenProvider.getTokenAsync().thenCompose(token -> {
                try {
                    return this.client.sendRequestAsync(this.createRequest((String)token)).thenCompose(this::getResponseFuture);
                }
                catch (Auth0Exception e) {
                    future.completeExceptionally(e);
                    return future;
                }
            });
        }
        try {
            return this.client.sendRequestAsync(this.createRequest(null)).thenCompose(this::getResponseFuture);
        }
        catch (Auth0Exception e) {
            future.completeExceptionally(e);
            return future;
        }
    }

    private CompletableFuture<Response<T>> getResponseFuture(Auth0HttpResponse httpResponse) {
        CompletableFuture<Response<T>> future = new CompletableFuture<Response<T>>();
        try {
            T body = this.parseResponseBody(httpResponse);
            future = CompletableFuture.completedFuture(new ResponseImpl<T>(httpResponse.getHeaders(), body, httpResponse.getCode()));
        }
        catch (Auth0Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        return future;
    }

    protected String getContentType() {
        return CONTENT_TYPE_APPLICATION_JSON;
    }

    protected Auth0Exception createResponseException(Auth0HttpResponse response) {
        if (response.getCode() == 429) {
            return this.createRateLimitException(response);
        }
        String payload = response.getBody();
        MapType mapType = this.mapper.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
        try {
            Map values2 = (Map)this.mapper.readValue(payload, (JavaType)mapType);
            return new APIException(values2, response.getCode());
        }
        catch (IOException e) {
            return new APIException(payload, response.getCode(), e);
        }
    }

    private RateLimitException createRateLimitException(Auth0HttpResponse response) {
        long limit = Long.parseLong(response.getHeader("x-ratelimit-limit", "-1"));
        long remaining = Long.parseLong(response.getHeader("x-ratelimit-remaining", "-1"));
        long reset = Long.parseLong(response.getHeader("x-ratelimit-reset", "-1"));
        String payload = response.getBody();
        MapType mapType = this.mapper.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
        try {
            Map values2 = (Map)this.mapper.readValue(payload, (JavaType)mapType);
            return new RateLimitException(limit, remaining, reset, values2);
        }
        catch (IOException e) {
            return new RateLimitException(limit, remaining, reset);
        }
    }

    @Override
    public BaseRequest<T> addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    @Override
    public BaseRequest<T> addParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public BaseRequest<T> setBody(Object value) {
        this.body = value;
        return this;
    }
}

