/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.net;

import com.auth0.exception.Auth0Exception;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class RateLimitInterceptor
implements Interceptor {
    private final int maxRetries;
    private final CheckedConsumer<? extends ExecutionAttemptedEvent<Response>> retryListener;
    static final Long INITIAL_INTERVAL = 100L;
    static final Long MAX_INTERVAL = 1000L;
    static final Double JITTER = 0.2;

    public RateLimitInterceptor(int maxRetries) {
        this(maxRetries, null);
    }

    RateLimitInterceptor(int maxRetries, CheckedConsumer<? extends ExecutionAttemptedEvent<Response>> retryListener) {
        this.maxRetries = maxRetries;
        this.retryListener = retryListener;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        if (this.maxRetries == 0) {
            return chain.proceed(chain.request());
        }
        RetryPolicy retryPolicy = (RetryPolicy)new RetryPolicy().withMaxRetries(this.maxRetries).withBackoff(INITIAL_INTERVAL, MAX_INTERVAL, ChronoUnit.MILLIS).withJitter(JITTER).handleResultIf(response -> response.code() == 429);
        if (this.retryListener != null) {
            retryPolicy.onRetry(this.retryListener);
        }
        try {
            return Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(context -> {
                if (context.getLastResult() != null) {
                    ((Response)context.getLastResult()).close();
                }
                return chain.proceed(chain.request());
            });
        }
        catch (FailsafeException fe) {
            throw new Auth0Exception("Failed to execute request", fe.getCause());
        }
    }
}

