/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.utils.tokens;

import com.auth0.exception.IdTokenValidationException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.JWTVerifier;
import com.auth0.utils.Asserts;
import com.auth0.utils.tokens.HS256SignatureVerifier;
import com.auth0.utils.tokens.PublicKeyProvider;
import com.auth0.utils.tokens.RS256SignatureVerifier;

public abstract class SignatureVerifier {
    private final JWTVerifier verifier;
    private final Algorithm algorithm;

    public static SignatureVerifier forHS256(String secret) {
        return new HS256SignatureVerifier(secret);
    }

    public static SignatureVerifier forRS256(PublicKeyProvider publicKeyProvider) {
        return new RS256SignatureVerifier(publicKeyProvider);
    }

    SignatureVerifier(Algorithm algorithm) {
        Asserts.assertNotNull(algorithm, "algorithm");
        this.algorithm = algorithm;
        this.verifier = JWT.require(algorithm).ignoreIssuedAt().build();
    }

    DecodedJWT verifySignature(String token) throws IdTokenValidationException {
        DecodedJWT decoded = this.decodeToken(token);
        try {
            this.verifier.verify(decoded);
        }
        catch (AlgorithmMismatchException algorithmMismatchException) {
            String message = String.format("Signature algorithm of \"%s\" is not supported. Expected the ID token to be signed with \"%s\"", decoded.getAlgorithm(), this.algorithm.getName());
            throw new IdTokenValidationException(message, algorithmMismatchException);
        }
        catch (SignatureVerificationException signatureVerificationException) {
            throw new IdTokenValidationException("Invalid ID token signature", signatureVerificationException);
        }
        catch (JWTVerificationException jWTVerificationException) {
            // empty catch block
        }
        return decoded;
    }

    private DecodedJWT decodeToken(String token) throws IdTokenValidationException {
        try {
            return JWT.decode(token);
        }
        catch (JWTDecodeException e) {
            throw new IdTokenValidationException("ID token could not be decoded", e);
        }
    }
}

